/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.docset;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AllDocIdSet;
import org.elasticsearch.common.lucene.docset.MatchDocIdSetIterator;

public class NotDocIdSet
extends DocIdSet {
    private final DocIdSet set;
    private final int maxDoc;

    public NotDocIdSet(DocIdSet set, int maxDoc) {
        this.maxDoc = maxDoc;
        this.set = set;
    }

    public boolean isCacheable() {
        return this.set.isCacheable();
    }

    public Bits bits() throws IOException {
        Bits bits = this.set.bits();
        if (bits == null) {
            return null;
        }
        return new NotBits(bits);
    }

    public DocIdSetIterator iterator() throws IOException {
        DocIdSetIterator it = this.set.iterator();
        if (it == null) {
            return new AllDocIdSet.Iterator(this.maxDoc);
        }
        Bits bits = this.set.bits();
        if (bits != null) {
            return new BitsBasedIterator(bits);
        }
        return new IteratorBasedIterator(this.maxDoc, it);
    }

    public static class IteratorBasedIterator
    extends DocIdSetIterator {
        private final int max;
        private DocIdSetIterator it1;
        private int lastReturn = -1;
        private int innerDocid = -1;
        private final long cost;

        IteratorBasedIterator(int max, DocIdSetIterator it) throws IOException {
            this.max = max;
            this.it1 = it;
            this.cost = this.it1.cost();
            this.innerDocid = this.it1.nextDoc();
            if (this.innerDocid == Integer.MAX_VALUE) {
                this.it1 = null;
            }
        }

        public int docID() {
            return this.lastReturn;
        }

        public int nextDoc() throws IOException {
            return this.advance(0);
        }

        public int advance(int target) throws IOException {
            if (this.lastReturn == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (target <= this.lastReturn) {
                target = this.lastReturn + 1;
            }
            if (this.it1 != null && this.innerDocid < target && (this.innerDocid = this.it1.advance(target)) == Integer.MAX_VALUE) {
                this.it1 = null;
            }
            while (this.it1 != null && this.innerDocid == target) {
                if (++target >= this.max) {
                    this.lastReturn = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.innerDocid = this.it1.advance(target);
                if (this.innerDocid != Integer.MAX_VALUE) continue;
                this.it1 = null;
            }
            if (target >= this.max) {
                this.lastReturn = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.lastReturn = target;
            return this.lastReturn;
        }

        public long cost() {
            return this.cost;
        }
    }

    public static class BitsBasedIterator
    extends MatchDocIdSetIterator {
        private final Bits bits;

        public BitsBasedIterator(Bits bits) {
            super(bits.length());
            this.bits = bits;
        }

        @Override
        protected boolean matchDoc(int doc) {
            return !this.bits.get(doc);
        }

        public long cost() {
            return this.bits.length();
        }
    }

    public static class NotBits
    implements Bits {
        private final Bits bits;

        public NotBits(Bits bits) {
            this.bits = bits;
        }

        public boolean get(int index) {
            return !this.bits.get(index);
        }

        public int length() {
            return this.bits.length();
        }
    }
}

