/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class GetFieldMappingsIndexRequest
extends SingleCustomOperationRequest<GetFieldMappingsIndexRequest> {
    private String index;
    private boolean probablySingleFieldRequest;
    private boolean includeDefaults;
    private String[] fields = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;

    GetFieldMappingsIndexRequest() {
    }

    GetFieldMappingsIndexRequest(GetFieldMappingsRequest other, String index, boolean probablySingleFieldRequest) {
        this.preferLocal(other.local);
        this.probablySingleFieldRequest = probablySingleFieldRequest;
        this.includeDefaults = other.includeDefaults();
        this.types = other.types();
        this.fields = other.fields();
        this.index = index;
    }

    public String index() {
        return this.index;
    }

    public String[] types() {
        return this.types;
    }

    public String[] fields() {
        return this.fields;
    }

    public boolean probablySingleFieldRequest() {
        return this.probablySingleFieldRequest;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    public GetFieldMappingsIndexRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeStringArray(this.types);
        out.writeStringArray(this.fields);
        out.writeBoolean(this.includeDefaults);
        out.writeBoolean(this.probablySingleFieldRequest);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.types = in.readStringArray();
        this.fields = in.readStringArray();
        this.includeDefaults = in.readBoolean();
        this.probablySingleFieldRequest = in.readBoolean();
    }
}

