/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class WritableHandler {
    public Class<? extends WritableComparable> type;
    private Text text = new Text();
    private LongWritable longWritable = new LongWritable();
    private IntWritable intWritable = new IntWritable();
    private FloatWritable floatWritable = new FloatWritable();
    private DoubleWritable doubleWritable = new DoubleWritable();
    private static final Text NULL_TEXT = new Text("null");
    private static final LongWritable NULL_LONG = new LongWritable(Long.MIN_VALUE);
    private static final IntWritable NULL_INT = new IntWritable(Integer.MIN_VALUE);
    private static final FloatWritable NULL_FLOAT = new FloatWritable(Float.NaN);
    private static final DoubleWritable NULL_DOUBLE = new DoubleWritable(Double.NaN);

    public WritableHandler(Class<? extends WritableComparable> type) {
        this.type = type;
    }

    public WritableComparable set(String s) {
        if (null == s) {
            return NULL_TEXT;
        }
        if (this.type.equals(LongWritable.class)) {
            this.longWritable.set(Long.valueOf(s).longValue());
            return this.longWritable;
        }
        if (this.type.equals(IntWritable.class)) {
            this.intWritable.set(Integer.valueOf(s).intValue());
            return this.intWritable;
        }
        if (this.type.equals(DoubleWritable.class)) {
            this.doubleWritable.set(Double.valueOf(s).doubleValue());
            return this.doubleWritable;
        }
        if (this.type.equals(FloatWritable.class)) {
            this.floatWritable.set(Float.valueOf(s).floatValue());
            return this.floatWritable;
        }
        this.text.set(s);
        return this.text;
    }

    public WritableComparable set(Long l) {
        if (null == l) {
            return NULL_LONG;
        }
        if (this.type.equals(LongWritable.class)) {
            this.longWritable.set(l.longValue());
            return this.longWritable;
        }
        if (this.type.equals(IntWritable.class)) {
            this.intWritable.set(l.intValue());
            return this.intWritable;
        }
        if (this.type.equals(DoubleWritable.class)) {
            this.doubleWritable.set(l.doubleValue());
            return this.doubleWritable;
        }
        if (this.type.equals(FloatWritable.class)) {
            this.floatWritable.set(l.floatValue());
            return this.floatWritable;
        }
        this.text.set(String.valueOf(l));
        return this.text;
    }

    public WritableComparable set(Integer i) {
        if (null == i) {
            return NULL_INT;
        }
        if (this.type.equals(LongWritable.class)) {
            this.longWritable.set(i.longValue());
            return this.longWritable;
        }
        if (this.type.equals(IntWritable.class)) {
            this.intWritable.set(i.intValue());
            return this.intWritable;
        }
        if (this.type.equals(DoubleWritable.class)) {
            this.doubleWritable.set(i.doubleValue());
            return this.doubleWritable;
        }
        if (this.type.equals(FloatWritable.class)) {
            this.floatWritable.set(i.floatValue());
            return this.floatWritable;
        }
        this.text.set(String.valueOf(i));
        return this.text;
    }

    public WritableComparable set(Double d) {
        if (null == d) {
            return NULL_DOUBLE;
        }
        if (this.type.equals(LongWritable.class)) {
            this.longWritable.set(d.longValue());
            return this.longWritable;
        }
        if (this.type.equals(IntWritable.class)) {
            this.intWritable.set(d.intValue());
            return this.intWritable;
        }
        if (this.type.equals(DoubleWritable.class)) {
            this.doubleWritable.set(d.doubleValue());
            return this.doubleWritable;
        }
        if (this.type.equals(FloatWritable.class)) {
            this.floatWritable.set(d.floatValue());
            return this.floatWritable;
        }
        this.text.set(String.valueOf(d));
        return this.text;
    }

    public WritableComparable set(Float f) {
        if (null == f) {
            return NULL_FLOAT;
        }
        if (this.type.equals(LongWritable.class)) {
            this.longWritable.set(f.longValue());
            return this.longWritable;
        }
        if (this.type.equals(IntWritable.class)) {
            this.intWritable.set(f.intValue());
            return this.intWritable;
        }
        if (this.type.equals(DoubleWritable.class)) {
            this.doubleWritable.set(f.doubleValue());
            return this.doubleWritable;
        }
        if (this.type.equals(FloatWritable.class)) {
            this.floatWritable.set(f.floatValue());
            return this.floatWritable;
        }
        this.text.set(String.valueOf(f));
        return this.text;
    }

    public WritableComparable set(Object object) {
        if (null == object) {
            if (this.type.equals(Text.class)) {
                return NULL_TEXT;
            }
            if (this.type.equals(LongWritable.class)) {
                return NULL_LONG;
            }
            if (this.type.equals(IntWritable.class)) {
                return NULL_INT;
            }
            if (this.type.equals(DoubleWritable.class)) {
                return NULL_DOUBLE;
            }
            if (this.type.equals(FloatWritable.class)) {
                return NULL_FLOAT;
            }
            return NULL_TEXT;
        }
        if (object instanceof Long) {
            return this.set((Long)object);
        }
        if (object instanceof Integer) {
            return this.set((Integer)object);
        }
        if (object instanceof Double) {
            return this.set((Double)object);
        }
        if (object instanceof Float) {
            return this.set((Float)object);
        }
        return this.set(object.toString());
    }
}

