/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopProperty;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import java.util.ArrayList;

public class ElementPicker {
    protected ElementPicker() {
    }

    public static String getPropertyAsString(HadoopElement element, String key) {
        if (key.equals("_id") || key.equals("id")) {
            return element.getId().toString();
        }
        if (key.equals("_properties")) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            for (HadoopProperty property : element.getProperties()) {
                properties.put((Object)property.getType().getName(), property.getValue());
            }
            properties.put((Object)"_id", element.getId());
            if (element instanceof HadoopEdge) {
                properties.put((Object)"_label", (Object)((HadoopEdge)element).getLabel());
            }
            return properties.toString();
        }
        if (key.equals("label") && element instanceof HadoopEdge) {
            return ((HadoopEdge)element).getLabel();
        }
        if (element instanceof HadoopVertex) {
            ArrayList values = new ArrayList();
            Iterables.addAll(values, ((HadoopVertex)element).getProperties(key));
            if (values.size() == 0) {
                return "null";
            }
            if (values.size() == 1) {
                return values.iterator().next().toString();
            }
            return ((Object)values).toString();
        }
        Object value = element.getProperty(key);
        if (null != value) {
            return value.toString();
        }
        return "null";
    }

    public static Object getProperty(HadoopElement element, String key) {
        if (key.equals("_id") || key.equals("id")) {
            return element.getId();
        }
        if (key.equals("_properties")) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            for (HadoopProperty property : element.getProperties()) {
                properties.put((Object)property.getType().getName(), property.getValue());
            }
            properties.put((Object)"_id", element.getId());
            return properties;
        }
        if (key.equals("label") && element instanceof HadoopEdge) {
            return ((HadoopEdge)element).getLabel();
        }
        if (element instanceof HadoopVertex) {
            ArrayList values = new ArrayList();
            Iterables.addAll(values, ((HadoopVertex)element).getProperties(key));
            if (values.size() == 0) {
                return null;
            }
            if (values.size() == 1) {
                return values.iterator().next();
            }
            return values;
        }
        return element.getProperty(key);
    }
}

