/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class VerticesEdgesMapReduce {
    public static final String DIRECTION = Tokens.makeNamespace(VerticesEdgesMapReduce.class) + ".direction";
    public static final String LABELS = Tokens.makeNamespace(VerticesEdgesMapReduce.class) + ".labels";

    public static Configuration createConfiguration(Direction direction, String ... labels) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(DIRECTION, direction.name());
        configuration.setStrings(LABELS, labels);
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, HadoopVertex> {
        private Direction direction;
        private String[] labels;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            if (!this.direction.equals((Object)Direction.BOTH)) {
                this.direction = this.direction.opposite();
            }
            this.labels = context.getConfiguration().getStrings(LABELS);
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            ArrayList<HadoopEdge> edges = new ArrayList<HadoopEdge>();
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    continue;
                }
                edges.add((HadoopEdge)holder.get());
            }
            block1: for (Edge e : vertex.getEdges(this.direction, this.labels)) {
                for (HadoopEdge edge : edges) {
                    if (!e.getId().equals(edge.getId())) continue;
                    ((HadoopEdge)e).getPaths(edge, false);
                    continue block1;
                }
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder> {
        private Direction direction;
        private String[] labels;
        private boolean trackPaths;
        private final Holder<HadoopPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            this.labels = context.getConfiguration().getStrings(LABELS, new String[0]);
            this.trackPaths = context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-paths", false);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.hasPaths()) {
                List<List<HadoopPathElement.MicroElement>> paths;
                HadoopEdge shellEdge;
                HadoopEdge edge;
                long edgesTraversed = 0L;
                if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge e : value.getEdges(Direction.IN, this.labels)) {
                        edge = (HadoopEdge)e;
                        shellEdge = new HadoopEdge(context.getConfiguration(), edge.getIdAsLong(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel());
                        if (this.trackPaths) {
                            paths = this.clonePaths(value, new HadoopEdge.MicroEdge(edge.getIdAsLong()));
                            edge.addPaths(paths, false);
                            shellEdge.addPaths(paths, false);
                        } else {
                            edge.getPaths(value, false);
                            shellEdge.getPaths(value, false);
                        }
                        this.longWritable.set(edge.getVertexId(Direction.OUT));
                        context.write((Object)this.longWritable, this.holder.set('p', shellEdge));
                        ++edgesTraversed;
                    }
                }
                if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                    for (Edge e : value.getEdges(Direction.OUT, this.labels)) {
                        edge = (HadoopEdge)e;
                        shellEdge = new HadoopEdge(context.getConfiguration(), edge.getIdAsLong(), edge.getVertexId(Direction.OUT), edge.getVertexId(Direction.IN), edge.getLabel());
                        if (this.trackPaths) {
                            paths = this.clonePaths(value, new HadoopEdge.MicroEdge(edge.getIdAsLong()));
                            edge.addPaths(paths, false);
                            shellEdge.addPaths(paths, false);
                        } else {
                            edge.getPaths(value, false);
                            shellEdge.getPaths(value, false);
                        }
                        this.longWritable.set(edge.getVertexId(Direction.IN));
                        context.write((Object)this.longWritable, this.holder.set('p', shellEdge));
                        ++edgesTraversed;
                    }
                }
                value.clearPaths();
                context.getCounter((Enum)Counters.EDGES_TRAVERSED).increment(edgesTraversed);
            }
            this.longWritable.set(value.getIdAsLong());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }

        private List<List<HadoopPathElement.MicroElement>> clonePaths(HadoopVertex vertex, HadoopEdge.MicroEdge edge) {
            ArrayList<List<HadoopPathElement.MicroElement>> paths = new ArrayList<List<HadoopPathElement.MicroElement>>();
            for (List<HadoopPathElement.MicroElement> path : vertex.getPaths()) {
                ArrayList<HadoopPathElement.MicroElement> p = new ArrayList<HadoopPathElement.MicroElement>();
                p.addAll(path);
                p.add(edge);
                paths.add(p);
            }
            return paths;
        }
    }

    public static enum Counters {
        EDGES_TRAVERSED;

    }
}

