/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public class PathMap {
    public static final String CLASS = Tokens.makeNamespace(PathMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.setBoolean("titan.hadoop.pipeline.track-paths", true);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, Text> {
        private boolean isVertex;
        private final Text textWritable = new Text();
        private SafeMapperOutputs outputs;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.outputs = new SafeMapperOutputs(context);
            if (!context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-paths", false)) {
                throw new IllegalStateException(PathMap.class.getSimpleName() + " requires that paths be enabled");
            }
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex && value.hasPaths()) {
                for (List<HadoopPathElement.MicroElement> path : value.getPaths()) {
                    this.textWritable.set(path.toString());
                    this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.textWritable);
                }
                context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    for (List<HadoopPathElement.MicroElement> path : edge.getPaths()) {
                        this.textWritable.set(path.toString());
                        this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.textWritable);
                    }
                    ++edgesProcessed;
                }
                context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

