/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.CounterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementPicker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeReducerOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.WritableHandler;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class ValueGroupCountMapReduce {
    public static final String PROPERTY = Tokens.makeNamespace(ValueGroupCountMapReduce.class) + ".property";
    public static final String CLASS = Tokens.makeNamespace(ValueGroupCountMapReduce.class) + ".class";
    public static final String TYPE = Tokens.makeNamespace(ValueGroupCountMapReduce.class) + ".type";

    public static Configuration createConfiguration(Class<? extends Element> klass, String key, Class<? extends Writable> type) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(PROPERTY, key);
        configuration.setClass(TYPE, type, Writable.class);
        return configuration;
    }

    public static class Reduce
    extends Reducer<WritableComparable, LongWritable, WritableComparable, LongWritable> {
        private SafeReducerOutputs outputs;
        private final LongWritable longWritable = new LongWritable();

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs = new SafeReducerOutputs(context);
        }

        public void reduce(WritableComparable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable token : values) {
                totalCount += token.get();
            }
            this.longWritable.set(totalCount);
            this.outputs.write("sideeffect", (Writable)key, (Writable)this.longWritable);
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static class Combiner
    extends Reducer<WritableComparable, LongWritable, WritableComparable, LongWritable> {
        private final LongWritable longWritable = new LongWritable();

        public void reduce(WritableComparable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable token : values) {
                totalCount += token.get();
            }
            this.longWritable.set(totalCount);
            context.write((Object)key, (Object)this.longWritable);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, WritableComparable, LongWritable> {
        private String property;
        private WritableHandler handler;
        private boolean isVertex;
        private CounterMap<Object> map;
        private int mapSpillOver;
        private SafeMapperOutputs outputs;
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.map = new CounterMap();
            this.mapSpillOver = context.getConfiguration().getInt("titan.hadoop.pipeline.map-spill-over", Tokens.DEFAULT_MAP_SPILL_OVER);
            this.property = context.getConfiguration().get(PROPERTY);
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.handler = new WritableHandler(context.getConfiguration().getClass(TYPE, Text.class, WritableComparable.class));
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    this.map.incr(ElementPicker.getProperty(value, this.property), value.pathCount());
                    context.getCounter((Enum)Counters.PROPERTIES_COUNTED).increment(1L);
                }
            } else {
                for (Edge e : value.getEdges(Direction.OUT)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    this.map.incr(ElementPicker.getProperty(edge, this.property), edge.pathCount());
                    context.getCounter((Enum)Counters.PROPERTIES_COUNTED).increment(1L);
                }
            }
            if (this.map.size() > this.mapSpillOver) {
                this.dischargeMap(context);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void dischargeMap(Mapper.Context context) throws IOException, InterruptedException {
            for (Map.Entry entry : this.map.entrySet()) {
                this.longWritable.set(((Long)entry.getValue()).longValue());
                context.write((Object)this.handler.set(entry.getKey()), (Object)this.longWritable);
            }
            this.map.clear();
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.dischargeMap(context);
            this.outputs.close();
        }
    }

    public static enum Counters {
        PROPERTIES_COUNTED;

    }
}

