/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.CounterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class LinkMapReduce {
    public static final String DIRECTION = Tokens.makeNamespace(LinkMapReduce.class) + ".direction";
    public static final String LABEL = Tokens.makeNamespace(LinkMapReduce.class) + ".label";
    public static final String STEP = Tokens.makeNamespace(LinkMapReduce.class) + ".step";
    public static final String MERGE_DUPLICATES = Tokens.makeNamespace(LinkMapReduce.class) + ".mergeDuplicates";
    public static final String MERGE_WEIGHT_KEY = Tokens.makeNamespace(LinkMapReduce.class) + ".mergeWeightKey";
    public static final String NO_WEIGHT_KEY = "_";

    public static Configuration createConfiguration(Direction direction, String label, int step, String mergeWeightKey) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setInt(STEP, step);
        configuration.set(DIRECTION, direction.name());
        configuration.set(LABEL, label);
        if (null == mergeWeightKey) {
            configuration.setBoolean(MERGE_DUPLICATES, false);
            configuration.set(MERGE_WEIGHT_KEY, NO_WEIGHT_KEY);
        } else {
            configuration.setBoolean(MERGE_DUPLICATES, true);
            configuration.set(MERGE_WEIGHT_KEY, mergeWeightKey);
        }
        configuration.setBoolean("titan.hadoop.pipeline.track-paths", true);
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, HadoopVertex> {
        private Direction direction;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            this.direction = this.direction.opposite();
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesCreated = 0L;
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    continue;
                }
                if (tag == 'e') {
                    vertex.addEdge(this.direction, (HadoopEdge)holder.get());
                    ++edgesCreated;
                    continue;
                }
                vertex.addEdges(Direction.BOTH, (HadoopVertex)holder.get());
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
            if (this.direction.equals((Object)Direction.OUT)) {
                context.getCounter((Enum)Counters.OUT_EDGES_CREATED).increment(edgesCreated);
            } else {
                context.getCounter((Enum)Counters.IN_EDGES_CREATED).increment(edgesCreated);
            }
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private Direction direction;
        private final Holder<HadoopVertex> holder = new Holder();

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            this.direction = this.direction.opposite();
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesCreated = 0L;
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            int outTag = 120;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    outTag = 118;
                    continue;
                }
                if (tag == 'e') {
                    vertex.addEdge(this.direction, (HadoopEdge)holder.get());
                    ++edgesCreated;
                    continue;
                }
                vertex.addEdges(Direction.BOTH, (HadoopVertex)holder.get());
            }
            context.write((Object)key, this.holder.set((char)outTag, vertex));
            if (this.direction.equals((Object)Direction.OUT)) {
                context.getCounter((Enum)Counters.OUT_EDGES_CREATED).increment(edgesCreated);
            } else {
                context.getCounter((Enum)Counters.IN_EDGES_CREATED).increment(edgesCreated);
            }
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder> {
        private Direction direction;
        private String label;
        private int step;
        private final Holder<HadoopPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private boolean mergeDuplicates;
        private String mergeWeightKey;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.step = context.getConfiguration().getInt(STEP, -1);
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
            this.label = context.getConfiguration().get(LABEL);
            this.mergeDuplicates = context.getConfiguration().getBoolean(MERGE_DUPLICATES, false);
            this.mergeWeightKey = context.getConfiguration().get(MERGE_WEIGHT_KEY, LinkMapReduce.NO_WEIGHT_KEY);
            if (!context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-paths", false)) {
                throw new IllegalStateException(LinkMapReduce.class.getSimpleName() + " requires that paths be enabled");
            }
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long valueId = value.getIdAsLong();
            if (value.hasPaths()) {
                long edgesCreated = 0L;
                if (this.mergeDuplicates) {
                    CounterMap<Long> map = new CounterMap<Long>();
                    for (List<HadoopPathElement.MicroElement> list : value.getPaths()) {
                        map.incr(list.get(this.step).getId(), 1L);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        long linkElementId = (Long)entry.getKey();
                        HadoopEdge edge = this.direction.equals((Object)Direction.IN) ? new HadoopEdge(context.getConfiguration(), linkElementId, valueId, this.label) : new HadoopEdge(context.getConfiguration(), valueId, linkElementId, this.label);
                        if (!this.mergeWeightKey.equals(LinkMapReduce.NO_WEIGHT_KEY)) {
                            edge.setProperty(this.mergeWeightKey, entry.getValue());
                        }
                        value.addEdge(this.direction, edge);
                        ++edgesCreated;
                        this.longWritable.set(linkElementId);
                        context.write((Object)this.longWritable, this.holder.set('e', edge));
                    }
                } else {
                    for (List<HadoopPathElement.MicroElement> path : value.getPaths()) {
                        long l = path.get(this.step).getId();
                        HadoopEdge edge = this.direction.equals((Object)Direction.IN) ? new HadoopEdge(context.getConfiguration(), l, valueId, this.label) : new HadoopEdge(context.getConfiguration(), valueId, l, this.label);
                        value.addEdge(this.direction, edge);
                        ++edgesCreated;
                        this.longWritable.set(l);
                        context.write((Object)this.longWritable, this.holder.set('e', edge));
                    }
                }
                if (this.direction.equals((Object)Direction.OUT)) {
                    context.getCounter((Enum)Counters.OUT_EDGES_CREATED).increment(edgesCreated);
                } else {
                    context.getCounter((Enum)Counters.IN_EDGES_CREATED).increment(edgesCreated);
                }
            }
            this.longWritable.set(valueId);
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }

    public static enum Counters {
        IN_EDGES_CREATED,
        OUT_EDGES_CREATED;

    }
}

