/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.CounterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeReducerOutputs;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import groovy.lang.Closure;
import java.io.IOException;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class GroupCountMapReduce {
    public static final String KEY_CLOSURE = Tokens.makeNamespace(GroupCountMapReduce.class) + ".keyClosure";
    public static final String VALUE_CLOSURE = Tokens.makeNamespace(GroupCountMapReduce.class) + ".valueClosure";
    public static final String CLASS = Tokens.makeNamespace(GroupCountMapReduce.class) + ".class";
    private static final ScriptEngine engine = new GremlinGroovyScriptEngine();

    public static Configuration createConfiguration(Class<? extends Element> klass, String keyClosure, String valueClosure) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        if (null != keyClosure) {
            configuration.set(KEY_CLOSURE, keyClosure);
        }
        if (null != valueClosure) {
            configuration.set(VALUE_CLOSURE, valueClosure);
        }
        return configuration;
    }

    public static class Reduce
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private SafeReducerOutputs outputs;
        private final LongWritable longWritable = new LongWritable();

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs = new SafeReducerOutputs(context);
        }

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable token : values) {
                totalCount += token.get();
            }
            this.longWritable.set(totalCount);
            this.outputs.write("sideeffect", (Writable)key, (Writable)this.longWritable);
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static class Combiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private final LongWritable longWritable = new LongWritable();

        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable token : values) {
                totalCount += token.get();
            }
            this.longWritable.set(totalCount);
            context.write((Object)key, (Object)this.longWritable);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, Text, LongWritable> {
        private Closure keyClosure;
        private Closure valueClosure;
        private boolean isVertex;
        private CounterMap<Object> map;
        private int mapSpillOver;
        private SafeMapperOutputs outputs;
        private final Text textWritable = new Text();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            try {
                this.mapSpillOver = context.getConfiguration().getInt("titan.hadoop.pipeline.map-spill-over", Tokens.DEFAULT_MAP_SPILL_OVER);
                String keyClosureString = context.getConfiguration().get(KEY_CLOSURE, null);
                this.keyClosure = null == keyClosureString ? null : (Closure)engine.eval(keyClosureString);
                String valueClosureString = context.getConfiguration().get(VALUE_CLOSURE, null);
                this.valueClosure = null == valueClosureString ? null : (Closure)engine.eval(valueClosureString);
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.map = new CounterMap();
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    Object object = null == this.keyClosure ? new HadoopVertex.MicroVertex(value.getIdAsLong()) : this.keyClosure.call((Object)value);
                    Integer number = null == this.valueClosure ? (Number)1 : (Number)((Number)this.valueClosure.call((Object)value));
                    this.map.incr(object, ((Number)number).longValue() * value.pathCount());
                    context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
                }
            } else {
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    Object object = null == this.keyClosure ? new HadoopEdge.MicroEdge(edge.getIdAsLong()) : this.keyClosure.call((Object)edge);
                    Integer number = null == this.valueClosure ? (Number)1 : (Number)((Number)this.valueClosure.call((Object)edge));
                    this.map.incr(object, ((Number)number).longValue() * edge.pathCount());
                    ++edgesProcessed;
                }
                context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            }
            if (this.map.size() > this.mapSpillOver) {
                this.dischargeMap(context);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void dischargeMap(Mapper.Context context) throws IOException, InterruptedException {
            for (Map.Entry entry : this.map.entrySet()) {
                this.textWritable.set(null == entry.getKey() ? "null" : entry.getKey().toString());
                this.longWritable.set(((Long)entry.getValue()).longValue());
                context.write((Object)this.textWritable, (Object)this.longWritable);
            }
            this.map.clear();
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.dischargeMap(context);
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

