/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class DuplicateFilterMap {
    public static final String CLASS = Tokens.makeNamespace(DuplicateFilterMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean isVertex;
        private boolean trackPaths;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.trackPaths = context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-paths", false);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    if (this.trackPaths) {
                        List<HadoopPathElement.MicroElement> path = value.getPaths().get(0);
                        value.clearPaths();
                        value.addPath(path, false);
                    } else {
                        value.clearPaths();
                        value.startPath();
                    }
                    context.getCounter((Enum)Counters.VERTICES_DEDUPED).increment(1L);
                }
            } else {
                long counter = 0L;
                for (Edge e : value.getEdges(Direction.BOTH)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    if (this.trackPaths) {
                        List<HadoopPathElement.MicroElement> path = edge.getPaths().get(0);
                        edge.clearPaths();
                        edge.addPath(path, false);
                    } else {
                        edge.clearPaths();
                        edge.startPath();
                    }
                    ++counter;
                }
                context.getCounter((Enum)Counters.EDGES_DEDUPED).increment(counter);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_DEDUPED,
        EDGES_DEDUPED;

    }
}

