/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class IdentityMap {
    public static Configuration createConfiguration() {
        return new EmptyConfiguration();
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            context.getCounter((Enum)Counters.VERTEX_COUNT).increment(1L);
            context.getCounter((Enum)Counters.VERTEX_PROPERTY_COUNT).increment((long)value.getProperties().size());
            long edgeCount = 0L;
            long edgePropertyCount = 0L;
            for (Edge edge : value.getEdges(Direction.IN)) {
                ++edgeCount;
                edgePropertyCount += (long)((HadoopEdge)edge).getProperties().size();
            }
            context.getCounter((Enum)Counters.IN_EDGE_COUNT).increment(edgeCount);
            context.getCounter((Enum)Counters.IN_EDGE_PROPERTY_COUNT).increment(edgePropertyCount);
            edgeCount = 0L;
            edgePropertyCount = 0L;
            for (Edge edge : value.getEdges(Direction.OUT)) {
                ++edgeCount;
                edgePropertyCount += (long)((HadoopEdge)edge).getProperties().size();
            }
            context.getCounter((Enum)Counters.OUT_EDGE_COUNT).increment(edgeCount);
            context.getCounter((Enum)Counters.OUT_EDGE_PROPERTY_COUNT).increment(edgePropertyCount);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTEX_COUNT,
        OUT_EDGE_COUNT,
        IN_EDGE_COUNT,
        VERTEX_PROPERTY_COUNT,
        OUT_EDGE_PROPERTY_COUNT,
        IN_EDGE_PROPERTY_COUNT;

    }
}

