/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce;

import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.formats.FormatTools;
import com.thinkaurelius.titan.hadoop.formats.JobConfigurationFormat;
import com.thinkaurelius.titan.hadoop.hdfs.NoSideEffectFilter;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopCompiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.log4j.Logger;

public class Hadoop2Compiler
extends Configured
implements HadoopCompiler {
    private static final String MAPRED_COMPRESS_MAP_OUTPUT = "mapred.compress.map.output";
    private static final String MAPRED_MAP_OUTPUT_COMPRESSION_CODEC = "mapred.map.output.compression.codec";
    private static final String ARROW = " > ";
    private static final String MAPREDUCE_MAP_OUTPUT_COMPRESS = "mapreduce.map.output.compress";
    private static final String MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC = "mapreduce.map.output.compress.codec";
    private static final String MAPREDUCE_JOB_JAR = "mapreduce.job.jar";
    private static final String MAPRED_JAR = "mapred.jar";
    public static final Logger logger = Logger.getLogger(Hadoop2Compiler.class);
    private HadoopGraph graph;
    protected final List<Job> jobs = new ArrayList<Job>();
    private State state = State.NONE;
    private static final Class<? extends InputFormat> INTERMEDIATE_INPUT_FORMAT = SequenceFileInputFormat.class;
    private static final Class<? extends OutputFormat> INTERMEDIATE_OUTPUT_FORMAT = SequenceFileOutputFormat.class;
    private boolean trackPaths = false;
    private boolean trackState = false;

    public Hadoop2Compiler(HadoopGraph graph) {
        this.graph = graph;
        this.setConf(new Configuration());
        this.addConfiguration(this.graph.getConf());
    }

    private String makeClassName(Class klass) {
        return klass.getCanonicalName().replace(klass.getPackage().getName() + ".", "");
    }

    private void addConfiguration(Configuration configuration) {
        for (Map.Entry entry : configuration) {
            if (((String)entry.getKey()).equals("titan.hadoop.pipeline.track-paths") & Boolean.valueOf((String)entry.getValue())) {
                this.trackPaths = true;
                this.graph.setTrackPaths(true);
            }
            if (((String)entry.getKey()).equals("titan.hadoop.pipeline.track-state") & Boolean.valueOf((String)entry.getValue())) {
                this.trackState = true;
                this.graph.setTrackState(true);
            }
            this.getConf().set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public void addMapReduce(Class<? extends Mapper> mapper, Class<? extends Reducer> combiner, Class<? extends Reducer> reducer, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Class<? extends WritableComparable> reduceOutputKey, Class<? extends WritableComparable> reduceOutputValue, Configuration configuration) {
        this.addMapReduce(mapper, combiner, reducer, null, mapOutputKey, mapOutputValue, reduceOutputKey, reduceOutputValue, configuration);
    }

    @Override
    public void addMapReduce(Class<? extends Mapper> mapper, Class<? extends Reducer> combiner, Class<? extends Reducer> reducer, Class<? extends WritableComparator> comparator, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Class<? extends WritableComparable> reduceOutputKey, Class<? extends WritableComparable> reduceOutputValue, Configuration configuration) {
        try {
            Job job;
            if (State.NONE == this.state || State.REDUCER == this.state) {
                job = Job.getInstance((Configuration)this.getConf());
                job.setJobName(this.makeClassName(mapper) + ARROW + this.makeClassName(reducer));
                this.jobs.add(job);
            } else {
                job = this.jobs.get(this.jobs.size() - 1);
                job.setJobName(job.getJobName() + ARROW + this.makeClassName(mapper) + ARROW + this.makeClassName(reducer));
            }
            job.setNumReduceTasks(this.getConf().getInt("mapreduce.job.reduces", this.getConf().getInt("mapreduce.tasktracker.reduce.tasks.maximum", 1)));
            ChainMapper.addMapper((Job)job, mapper, NullWritable.class, HadoopVertex.class, mapOutputKey, mapOutputValue, (Configuration)configuration);
            ChainReducer.setReducer((Job)job, reducer, mapOutputKey, mapOutputValue, reduceOutputKey, reduceOutputValue, (Configuration)configuration);
            if (null != comparator) {
                job.setSortComparatorClass(comparator);
            }
            if (null != combiner) {
                job.setCombinerClass(combiner);
            }
            if (null == job.getConfiguration().get(MAPREDUCE_MAP_OUTPUT_COMPRESS, null)) {
                job.getConfiguration().setBoolean(MAPREDUCE_MAP_OUTPUT_COMPRESS, true);
            }
            if (null == job.getConfiguration().get(MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC, null)) {
                job.getConfiguration().setClass(MAPREDUCE_MAP_OUTPUT_COMPRESS_CODEC, DefaultCodec.class, CompressionCodec.class);
            }
            this.state = State.REDUCER;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void addMap(Class<? extends Mapper> mapper, Class<? extends WritableComparable> mapOutputKey, Class<? extends WritableComparable> mapOutputValue, Configuration configuration) {
        try {
            Job job;
            if (State.NONE == this.state) {
                job = Job.getInstance((Configuration)this.getConf());
                job.setNumReduceTasks(0);
                job.setJobName(this.makeClassName(mapper));
                this.jobs.add(job);
            } else {
                job = this.jobs.get(this.jobs.size() - 1);
                job.setJobName(job.getJobName() + ARROW + this.makeClassName(mapper));
            }
            if (State.MAPPER == this.state || State.NONE == this.state) {
                ChainMapper.addMapper((Job)job, mapper, NullWritable.class, HadoopVertex.class, mapOutputKey, mapOutputValue, (Configuration)configuration);
                this.state = State.MAPPER;
            } else {
                ChainReducer.addMapper((Job)job, mapper, NullWritable.class, HadoopVertex.class, mapOutputKey, mapOutputValue, (Configuration)configuration);
                this.state = State.REDUCER;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void completeSequence() {
    }

    @Override
    public void composeJobs() throws IOException {
        if (this.jobs.size() == 0) {
            return;
        }
        String hadoopFileJar = this.graph.getConf().get(MAPRED_JAR, null);
        if (null == hadoopFileJar) {
            if (new File("target/" + Tokens.TITAN_HADOOP_JOB_JAR).exists()) {
                hadoopFileJar = "target/" + Tokens.TITAN_HADOOP_JOB_JAR;
                logger.warn((Object)("Using the developer Titan/Hadoop job jar: " + hadoopFileJar));
            } else if (new File("../target/" + Tokens.TITAN_HADOOP_JOB_JAR).exists()) {
                hadoopFileJar = "../target/" + Tokens.TITAN_HADOOP_JOB_JAR;
                logger.warn((Object)("Using the developer Titan/Hadoop job jar: " + hadoopFileJar));
            } else if (new File("lib/" + Tokens.TITAN_HADOOP_JOB_JAR).exists()) {
                hadoopFileJar = "lib/" + Tokens.TITAN_HADOOP_JOB_JAR;
                logger.warn((Object)("Using the distribution Titan/Hadoop job jar: " + hadoopFileJar));
            } else if (new File("../lib/" + Tokens.TITAN_HADOOP_JOB_JAR).exists()) {
                hadoopFileJar = "../lib/" + Tokens.TITAN_HADOOP_JOB_JAR;
                logger.warn((Object)("Using the distribution Titan/Hadoop job jar: " + hadoopFileJar));
            } else {
                String titanHadoopHome = System.getenv("TITAN_HADOOP_HOME");
                if (null == titanHadoopHome || titanHadoopHome.isEmpty()) {
                    throw new IllegalStateException("TITAN_HADOOP_HOME must be set in order to locate the Titan/Hadoop job jar: " + Tokens.TITAN_HADOOP_JOB_JAR);
                }
                if (new File(titanHadoopHome + "/lib/" + Tokens.TITAN_HADOOP_JOB_JAR).exists()) {
                    hadoopFileJar = titanHadoopHome + "/lib/" + Tokens.TITAN_HADOOP_JOB_JAR;
                    logger.info((Object)("Using the distribution Titan/Hadoop job jar: " + hadoopFileJar));
                }
            }
        } else {
            logger.info((Object)("Using the provided Titan/Hadoop job jar: " + hadoopFileJar));
        }
        if (null == hadoopFileJar) {
            throw new IllegalStateException("The Titan/Hadoop job jar could not be found: " + Tokens.TITAN_HADOOP_JOB_JAR);
        }
        if (this.trackPaths) {
            logger.warn((Object)"Path tracking is enabled for this Titan/Hadoop job (space and time expensive)");
        }
        if (this.trackState) {
            logger.warn((Object)"State tracking is enabled for this Titan/Hadoop job (full deletes not possible)");
        }
        FileSystem hdfs = FileSystem.get((Configuration)this.graph.getConf());
        String outputJobPrefix = this.graph.getOutputLocation().toString() + "/" + "job";
        hdfs.mkdirs(this.graph.getOutputLocation());
        for (int i = 0; i < this.jobs.size(); ++i) {
            Job job = this.jobs.get(i);
            job.getConfiguration().setBoolean("titan.hadoop.pipeline.track-paths", this.trackPaths);
            job.getConfiguration().setBoolean("titan.hadoop.pipeline.track-state", this.trackState);
            job.setJar(hadoopFileJar);
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputJobPrefix + "-" + i));
            if (i == 0) {
                job.setInputFormatClass(this.graph.getGraphInputFormat());
                if (FileInputFormat.class.isAssignableFrom(this.graph.getGraphInputFormat())) {
                    FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.graph.getInputLocation()});
                    FileInputFormat.setInputPathFilter((Job)job, NoSideEffectFilter.class);
                }
            } else {
                job.setInputFormatClass(INTERMEDIATE_INPUT_FORMAT);
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(outputJobPrefix + "-" + (i - 1))});
                FileInputFormat.setInputPathFilter((Job)job, NoSideEffectFilter.class);
            }
            if (i == this.jobs.size() - 1) {
                LazyOutputFormat.setOutputFormatClass((Job)job, this.graph.getGraphOutputFormat());
                MultipleOutputs.addNamedOutput((Job)job, (String)"sideeffect", this.graph.getSideEffectOutputFormat(), (Class)job.getOutputKeyClass(), (Class)job.getOutputKeyClass());
                MultipleOutputs.addNamedOutput((Job)job, (String)"graph", this.graph.getGraphOutputFormat(), NullWritable.class, HadoopVertex.class);
                continue;
            }
            LazyOutputFormat.setOutputFormatClass((Job)job, INTERMEDIATE_OUTPUT_FORMAT);
            MultipleOutputs.addNamedOutput((Job)job, (String)"sideeffect", this.graph.getSideEffectOutputFormat(), (Class)job.getOutputKeyClass(), (Class)job.getOutputKeyClass());
            MultipleOutputs.addNamedOutput((Job)job, (String)"graph", INTERMEDIATE_OUTPUT_FORMAT, NullWritable.class, HadoopVertex.class);
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        String script = null;
        boolean showHeader = true;
        if (args.length == 2) {
            script = args[0];
            showHeader = Boolean.valueOf(args[1]);
        }
        FileSystem hdfs = FileSystem.get((Configuration)this.getConf());
        if (this.graph.getOutputLocationOverwrite() && hdfs.exists(this.graph.getOutputLocation())) {
            hdfs.delete(this.graph.getOutputLocation(), true);
        }
        if (showHeader) {
            logger.info((Object)"Titan/Hadoop: Distributed Graph Processing with Hadoop");
            logger.info((Object)"        ,");
            logger.info((Object)"    ,   |\\ ,__");
            logger.info((Object)"    |\\   \\/   `\\");
            logger.info((Object)"    \\ `-.:.     `\\");
            logger.info((Object)"     `-.__ `\\/\\/\\|");
            logger.info((Object)"        / `'/ () \\");
            logger.info((Object)"      .'   /\\     )");
            logger.info((Object)"   .-'  .'| \\  \\__");
            logger.info((Object)" .'  __(  \\  '`(()");
            logger.info((Object)"/_.'`  `.  |    )(");
            logger.info((Object)"         \\ |");
            logger.info((Object)"          |/");
        }
        if (null != script && !script.isEmpty()) {
            logger.info((Object)("Generating job chain: " + script));
        }
        this.composeJobs();
        logger.info((Object)("Compiled to " + this.jobs.size() + " MapReduce job(s)"));
        String jobPath = this.graph.getOutputLocation().toString() + "/" + "job";
        for (int i = 0; i < this.jobs.size(); ++i) {
            Job job = this.jobs.get(i);
            try {
                ((JobConfigurationFormat)FormatTools.getBaseOutputFormatClass(job).newInstance()).updateJob(job);
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.info((Object)("Executing job " + (i + 1) + " out of " + this.jobs.size() + ": " + job.getJobName()));
            logger.info((Object)("Job data location: " + jobPath + "-" + i));
            boolean success = job.waitForCompletion(true);
            if (i > 0) {
                Path path = new Path(jobPath + "-" + (i - 1));
                for (FileStatus temp : hdfs.globStatus(new Path(path.toString() + "/" + "graph" + "*"))) {
                    hdfs.delete(temp.getPath(), true);
                }
                for (FileStatus temp : hdfs.globStatus(new Path(path.toString() + "/" + "part" + "*"))) {
                    hdfs.delete(temp.getPath(), true);
                }
            }
            if (success) continue;
            logger.error((Object)"Titan/Hadoop job error -- remaining MapReduce jobs have been canceled");
            return -1;
        }
        return 0;
    }

    static enum State {
        MAPPER,
        REDUCER,
        NONE;

    }
}

