/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.input.current;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.RelationReader;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.idhandling.IDHandler;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.input.SystemTypeInspector;
import com.thinkaurelius.titan.hadoop.formats.titan.input.TitanHadoopSetupCommon;
import com.thinkaurelius.titan.hadoop.formats.titan.input.VertexReader;
import com.thinkaurelius.titan.hadoop.formats.titan.util.ConfigurationUtil;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;

public class TitanHadoopSetupImpl
extends TitanHadoopSetupCommon {
    private final StandardTitanGraph graph;
    private final StandardTitanTx tx;

    public TitanHadoopSetupImpl(org.apache.hadoop.conf.Configuration config) {
        BaseConfiguration titan = ConfigurationUtil.extractConfiguration(config, "titan.hadoop.graph.input.titan");
        this.graph = (StandardTitanGraph)TitanFactory.open((Configuration)titan);
        this.tx = (StandardTitanTx)this.graph.buildTransaction().readOnly().setVertexCacheSize(200).start();
    }

    @Override
    public TypeInspector getTypeInspector() {
        for (TitanSchemaCategory sc : TitanSchemaCategory.values()) {
            for (TitanVertex k : this.tx.getVertices((PropertyKey)BaseKey.SchemaCategory, (Object)sc)) {
                assert (k instanceof TitanSchemaVertex);
                TitanSchemaVertex s = (TitanSchemaVertex)k;
                String name = s.getName();
                Preconditions.checkNotNull((Object)name);
                TypeDefinitionMap dm = s.getDefinition();
                Preconditions.checkNotNull((Object)dm);
                s.getRelated(TypeDefinitionCategory.CONSISTENCY_MODIFIER, Direction.OUT);
                s.getRelated(TypeDefinitionCategory.CONSISTENCY_MODIFIER, Direction.IN);
            }
        }
        return this.tx;
    }

    @Override
    public SystemTypeInspector getSystemTypeInspector() {
        return new SystemTypeInspector(){

            @Override
            public boolean isSystemType(long typeid) {
                return IDManager.isSystemRelationTypeId((long)typeid);
            }

            @Override
            public boolean isVertexExistsSystemType(long typeid) {
                return typeid == BaseKey.VertexExists.getID();
            }

            @Override
            public boolean isTypeSystemType(long typeid) {
                return typeid == BaseKey.SchemaCategory.getID() || typeid == BaseKey.SchemaDefinitionProperty.getID() || typeid == BaseKey.SchemaDefinitionDesc.getID() || typeid == BaseKey.SchemaName.getID() || typeid == BaseLabel.SchemaDefinitionEdge.getID();
            }
        };
    }

    @Override
    public VertexReader getVertexReader() {
        return new VertexReader(){

            @Override
            public long getVertexId(StaticBuffer key) {
                return TitanHadoopSetupImpl.this.graph.getIDManager().getKeyID(key);
            }
        };
    }

    @Override
    public RelationReader getRelationReader(long vertexid) {
        return this.graph.getEdgeSerializer();
    }

    @Override
    public SliceQuery inputSlice(VertexQueryFilter inputFilter) {
        if (inputFilter.limit == 0) {
            StaticBuffer[] endPoints = IDHandler.getBounds((RelationCategory)RelationCategory.PROPERTY, (boolean)false);
            return new SliceQuery(endPoints[0], endPoints[1]).setLimit(Integer.MAX_VALUE);
        }
        return super.inputSlice(inputFilter);
    }

    @Override
    public void close() {
        this.tx.rollback();
        this.graph.shutdown();
    }
}

