/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.cassandra;

import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.TitanInputFormat;
import com.thinkaurelius.titan.hadoop.formats.titan.cassandra.TitanCassandraHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.titan.cassandra.TitanCassandraRecordReader;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanCassandraInputFormat
extends TitanInputFormat {
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_KEYSPACE = "titan.hadoop.graph.input.titan.storage.keyspace";
    private final ColumnFamilyInputFormat columnFamilyInputFormat = new ColumnFamilyInputFormat();
    private TitanCassandraHadoopGraph graph;
    private Configuration config;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.columnFamilyInputFormat.getSplits(jobContext);
    }

    public RecordReader<NullWritable, HadoopVertex> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new TitanCassandraRecordReader(this.graph, this.vertexQuery, (ColumnFamilyRecordReader)this.columnFamilyInputFormat.createRecordReader(inputSplit, taskAttemptContext));
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        this.graph = new TitanCassandraHadoopGraph(this.titanSetup);
        config.set("cassandra.input.keyspace", config.get(TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_KEYSPACE));
        ConfigHelper.setInputColumnFamily((Configuration)config, (String)ConfigHelper.getInputKeyspace((Configuration)config), (String)"edgestore");
        SlicePredicate predicate = new SlicePredicate();
        predicate.setSlice_range(this.getSliceRange(this.vertexQuery, config.getInt("cassandra.range.batch.size", Integer.MAX_VALUE)));
        ConfigHelper.setInputSlicePredicate((Configuration)config, (SlicePredicate)predicate);
        ConfigHelper.setInputInitialAddress((Configuration)config, (String)config.get("titan.hadoop.graph.input.titan.storage.hostname"));
        ConfigHelper.setInputRpcPort((Configuration)config, (String)config.get("titan.hadoop.graph.input.titan.storage.port"));
        config.set("autotype", "none");
        this.config = config;
    }

    private SliceRange getSliceRange(VertexQueryFilter inputFilter, int limit) {
        SliceQuery slice = this.titanSetup.inputSlice(inputFilter);
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(slice.getSliceStart().asByteBuffer());
        sliceRange.setFinish(slice.getSliceEnd().asByteBuffer());
        sliceRange.setCount(Math.min(limit, slice.getLimit()));
        return sliceRange;
    }

    public Configuration getConf() {
        return this.config;
    }
}

