/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.input.TitanHadoopSetup;
import com.thinkaurelius.titan.util.system.ConfigurationUtil;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;

public abstract class TitanInputFormat
extends InputFormat<NullWritable, HadoopVertex>
implements Configurable {
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN = "titan.hadoop.graph.input.titan";
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_HOSTNAME = "titan.hadoop.graph.input.titan.storage.hostname";
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_PORT = "titan.hadoop.graph.input.titan.storage.port";
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_VERION = "titan.hadoop.graph.input.titan.version";
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_VERION_DEFAULT = "current";
    private static final String SETUP_PACKAGE_PREFIX = "com.thinkaurelius.titan.hadoop.formats.titan.input.";
    private static final String SETUP_CLASS_NAME = ".TitanHadoopSetupImpl";
    protected VertexQueryFilter vertexQuery;
    protected boolean trackPaths;
    protected TitanHadoopSetup titanSetup;

    public void setConf(Configuration config) {
        this.vertexQuery = VertexQueryFilter.create(config);
        this.trackPaths = config.getBoolean("titan.hadoop.pipeline.track-paths", false);
        String titanVersion = config.get(TITAN_HADOOP_GRAPH_INPUT_TITAN_VERION, TITAN_HADOOP_GRAPH_INPUT_TITAN_VERION_DEFAULT);
        String className = SETUP_PACKAGE_PREFIX + titanVersion + SETUP_CLASS_NAME;
        this.titanSetup = (TitanHadoopSetup)ConfigurationUtil.instantiate((String)className, (Object[])new Object[]{config}, (Class[])new Class[]{Configuration.class});
    }
}

