/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.DefaultSchemaMaker;
import com.thinkaurelius.titan.graphdb.blueprints.BlueprintsDefaultSchemaMaker;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.BlueprintsGraphOutputMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class SchemaInferencerMapReduce {
    private static final long funnyLong = -123456789L;
    private static final LongWritable funnyKey = new LongWritable(-123456789L);

    public static Configuration createConfiguration() {
        return new EmptyConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private TitanGraph graph;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.graph = (TitanGraph)BlueprintsGraphOutputMapReduce.generateGraph(context.getConfiguration());
        }

        public void reduce(LongWritable key, Iterable<HadoopVertex> value, Reducer.Context context) throws IOException, InterruptedException {
            if (key.get() == -123456789L) {
                DefaultSchemaMaker typeMaker = BlueprintsDefaultSchemaMaker.INSTANCE;
                for (HadoopVertex vertex : value) {
                    for (String property : vertex.getPropertyKeys()) {
                        String property2 = property.substring(1);
                        if (property.startsWith("t")) {
                            if (null != this.graph.getRelationType(property2)) continue;
                            typeMaker.makePropertyKey(this.graph.makePropertyKey(property2));
                            context.getCounter((Enum)Counters.PROPERTY_KEYS_CREATED).increment(1L);
                            continue;
                        }
                        if (null != this.graph.getRelationType(property2)) continue;
                        typeMaker.makeEdgeLabel(this.graph.makeEdgeLabel(property2));
                        context.getCounter((Enum)Counters.EDGE_LABELS_CREATED).increment(1L);
                    }
                }
            } else {
                for (HadoopVertex vertex : value) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                }
            }
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.graph.commit();
            this.graph.shutdown();
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, HadoopVertex> {
        private HadoopVertex funnyVertex;
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.funnyVertex = new HadoopVertex(context.getConfiguration(), -123456789L);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            for (String property : value.getPropertyKeys()) {
                this.funnyVertex.setProperty("t" + property, Object.class.getName());
            }
            for (Edge edge : value.getEdges(Direction.OUT)) {
                this.funnyVertex.setProperty("l" + edge.getLabel(), String.class.getName());
                for (String property : edge.getPropertyKeys()) {
                    this.funnyVertex.setProperty("t" + property, Object.class.getName());
                }
            }
            this.longWritable.set(value.getIdAsLong());
            context.write((Object)this.longWritable, (Object)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)funnyKey, (Object)this.funnyVertex);
        }
    }

    public static enum Counters {
        EDGE_LABELS_CREATED,
        PROPERTY_KEYS_CREATED;

    }
}

