/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.graphson.GraphSONRecordReader;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class GraphSONInputFormat
extends FileInputFormat<NullWritable, HadoopVertex>
implements Configurable {
    private VertexQueryFilter vertexQuery;
    private Configuration config;

    public RecordReader<NullWritable, HadoopVertex> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new GraphSONRecordReader(this.vertexQuery);
    }

    protected boolean isSplitable(JobContext context, Path file) {
        return null == new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
    }

    public void setConf(Configuration config) {
        this.config = config;
        this.vertexQuery = VertexQueryFilter.create(config);
    }

    public Configuration getConf() {
        return this.config;
    }
}

