/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class EdgeListInputMapReduce {
    public static Configuration createConfiguration() {
        return new EmptyConfiguration();
    }

    public static class Reduce
    extends Reducer<LongWritable, HadoopVertex, NullWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<HadoopVertex> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (HadoopVertex value : values) {
                vertex.addEdges(Direction.BOTH, value);
                vertex.addAllProperties(value.getProperties());
            }
            context.getCounter((Enum)Counters.VERTICES_CREATED).increment(1L);
            context.getCounter((Enum)Counters.VERTEX_PROPERTIES_CREATED).increment((long)vertex.getProperties().size());
            context.getCounter((Enum)Counters.OUT_EDGES_CREATED).increment((long)((List)vertex.getEdges(Direction.OUT)).size());
            context.getCounter((Enum)Counters.IN_EDGES_CREATED).increment((long)((List)vertex.getEdges(Direction.IN)).size());
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, HadoopVertex, LongWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<HadoopVertex> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (HadoopVertex value : values) {
                vertex.addEdges(Direction.BOTH, value);
                vertex.addAllProperties(value.getProperties());
            }
            context.write((Object)key, (Object)vertex);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopElement, LongWritable, HadoopVertex> {
        private final HashMap<Long, HadoopVertex> map = new HashMap();
        private static final int MAX_MAP_SIZE = 5000;
        private final LongWritable longWritable = new LongWritable();
        private int counter = 0;

        public void map(NullWritable key, HadoopElement value, Mapper.Context context) throws IOException, InterruptedException {
            if (value instanceof HadoopEdge) {
                long outId = ((HadoopEdge)value).getVertexId(Direction.OUT);
                long inId = ((HadoopEdge)value).getVertexId(Direction.IN);
                HadoopVertex vertex = this.map.get(outId);
                if (null == vertex) {
                    vertex = new HadoopVertex(context.getConfiguration(), outId);
                    this.map.put(outId, vertex);
                }
                vertex.addEdge(Direction.OUT, (HadoopEdge)WritableUtils.clone((Writable)((HadoopEdge)value), (Configuration)context.getConfiguration()));
                ++this.counter;
                vertex = this.map.get(inId);
                if (null == vertex) {
                    vertex = new HadoopVertex(context.getConfiguration(), inId);
                    this.map.put(inId, vertex);
                }
                vertex.addEdge(Direction.IN, (HadoopEdge)WritableUtils.clone((Writable)((HadoopEdge)value), (Configuration)context.getConfiguration()));
                context.getCounter((Enum)Counters.EDGES_PROCESSED).increment(1L);
                ++this.counter;
            } else {
                long id = value.getIdAsLong();
                HadoopVertex vertex = this.map.get(id);
                if (null == vertex) {
                    vertex = new HadoopVertex(context.getConfiguration(), id);
                    this.map.put(id, vertex);
                }
                vertex.addAllProperties(value.getProperties());
                vertex.addEdges(Direction.BOTH, (HadoopVertex)WritableUtils.clone((Writable)((HadoopVertex)value), (Configuration)context.getConfiguration()));
                ++this.counter;
            }
            if (this.counter > 5000) {
                this.flush(context);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.flush(context);
        }

        private void flush(Mapper.Context context) throws IOException, InterruptedException {
            for (HadoopVertex vertex : this.map.values()) {
                this.longWritable.set(vertex.getIdAsLong());
                context.write((Object)this.longWritable, (Object)vertex);
                context.getCounter((Enum)Counters.VERTICES_EMITTED).increment(1L);
            }
            this.map.clear();
            this.counter = 0;
        }
    }

    public static enum Counters {
        EDGES_PROCESSED,
        VERTICES_EMITTED,
        IN_EDGES_CREATED,
        OUT_EDGES_CREATED,
        VERTICES_CREATED,
        VERTEX_PROPERTIES_CREATED;

    }
}

