/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.formats.titan.TitanOutputFormat;
import com.thinkaurelius.titan.hadoop.formats.titan.util.ConfigurationUtil;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import groovy.lang.MissingMethodException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BlueprintsGraphOutputMapReduce {
    private static final String GET_OR_CREATE_VERTEX = "getOrCreateVertex(hadoopVertex,graph,mapContext)";
    private static final String GET_OR_CREATE_EDGE = "getOrCreateEdge(hadoopEdge,titanOutVertex,titanInVertex,graph,mapContext)";
    private static final String HADOOP_VERTEX = "hadoopVertex";
    private static final String HADOOP_EDGE = "hadoopEdge";
    private static final String TITAN_OUT_VERTEX = "titanOutVertex";
    private static final String TITAN_IN_VERTEX = "titanInVertex";
    private static final String GRAPH = "graph";
    private static final String MAP_CONTEXT = "mapContext";
    public static final String TITAN_HADOOP_GRAPH_OUTPUT_BLUEPRINTS_SCRIPT_FILE = "titan.hadoop.graph.output.blueprints.script-file";
    public static final Logger LOGGER = Logger.getLogger(BlueprintsGraphOutputMapReduce.class);
    public static final String BLUEPRINTS_ID = "_bId0192834";
    public static final String ID_MAP_KEY = "_iDMaPKeY";

    public static Graph generateGraph(Configuration config) {
        Class format = config.getClass("titan.hadoop.graph.output.format", OutputFormat.class, OutputFormat.class);
        if (TitanOutputFormat.class.isAssignableFrom(format)) {
            return TitanFactory.open((org.apache.commons.configuration.Configuration)ConfigurationUtil.extractConfiguration(config, "titan.hadoop.graph.output.titan"));
        }
        throw new RuntimeException("The provide graph output format is not supported: " + format.getName());
    }

    public static Configuration createConfiguration() {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setBoolean(HadoopCompatLoader.getConfigKeys().getSpeculativeMapConfigKey(), false);
        configuration.setBoolean(HadoopCompatLoader.getConfigKeys().getSpeculativeReduceConfigKey(), false);
        return configuration;
    }

    public static class EdgeMap
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        static GremlinGroovyScriptEngine engine = null;
        static boolean firstRead = true;
        Graph graph;
        private static final HadoopVertex DEAD_HADOOP_VERTEX = new HadoopVertex();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.graph = BlueprintsGraphOutputMapReduce.generateGraph(context.getConfiguration());
            String file = context.getConfiguration().get(BlueprintsGraphOutputMapReduce.TITAN_HADOOP_GRAPH_OUTPUT_BLUEPRINTS_SCRIPT_FILE, null);
            if (null != file && firstRead) {
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                try {
                    engine = new GremlinGroovyScriptEngine();
                    engine.eval((Reader)new InputStreamReader((InputStream)fs.open(new Path(file))));
                    try {
                        engine.eval("getOrCreateEdge(null,null,null,null,null)");
                    }
                    catch (ScriptException se) {
                        if (se.getCause().getCause() instanceof MissingMethodException) {
                            engine = null;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                firstRead = false;
            }
            LOGGER.setLevel(Level.INFO);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                Map hadoopTitanIdMap = (Map)value.getProperty(BlueprintsGraphOutputMapReduce.ID_MAP_KEY);
                Object blueprintsId = value.getProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID);
                Vertex blueprintsVertex = null;
                if (null != blueprintsId) {
                    blueprintsVertex = this.graph.getVertex(blueprintsId);
                }
                if (null != blueprintsVertex) {
                    for (Edge hadoopEdge : value.getEdges(Direction.OUT)) {
                        Object otherId = hadoopTitanIdMap.get(hadoopEdge.getVertex(Direction.IN).getId());
                        Vertex otherVertex = null;
                        if (null != otherId) {
                            otherVertex = this.graph.getVertex(otherId);
                        }
                        if (null != otherVertex) {
                            this.getOrCreateEdge((HadoopEdge)hadoopEdge, blueprintsVertex, otherVertex, context);
                            continue;
                        }
                        LOGGER.warn((Object)("No target vertex: hadoopVertex[" + hadoopEdge.getVertex(Direction.IN).getId() + "] blueprintsVertex[" + otherId + "]"));
                        context.getCounter((Enum)Counters.NULL_VERTEX_EDGES_IGNORED).increment(1L);
                    }
                } else {
                    LOGGER.warn((Object)("No source vertex: hadoopVertex[" + NullWritable.get() + "] titanVertex[" + blueprintsId + "]"));
                    context.getCounter((Enum)Counters.NULL_VERTICES_IGNORED).increment(1L);
                }
                context.write((Object)NullWritable.get(), (Object)DEAD_HADOOP_VERTEX);
            }
            catch (Exception e) {
                if (this.graph instanceof TransactionalGraph) {
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                }
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.graph instanceof TransactionalGraph) {
                try {
                    ((TransactionalGraph)this.graph).commit();
                    context.getCounter((Enum)Counters.SUCCESSFUL_TRANSACTIONS).increment(1L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Could not commit transaction during Reduce.cleanup():", (Throwable)e);
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.graph.shutdown();
        }

        public Edge getOrCreateEdge(HadoopEdge hadoopEdge, Vertex blueprintsOutVertex, Vertex blueprintsInVertex, Mapper.Context context) throws InterruptedException {
            Edge blueprintsEdge;
            if (null == engine) {
                blueprintsEdge = this.graph.addEdge(null, blueprintsOutVertex, blueprintsInVertex, hadoopEdge.getLabel());
                context.getCounter((Enum)Counters.EDGES_WRITTEN).increment(1L);
                for (String property : hadoopEdge.getPropertyKeys()) {
                    blueprintsEdge.setProperty(property, hadoopEdge.getProperty(property));
                    context.getCounter((Enum)Counters.EDGE_PROPERTIES_WRITTEN).increment(1L);
                }
            } else {
                try {
                    Bindings bindings = engine.createBindings();
                    bindings.put(BlueprintsGraphOutputMapReduce.HADOOP_EDGE, (Object)hadoopEdge);
                    bindings.put(BlueprintsGraphOutputMapReduce.TITAN_OUT_VERTEX, (Object)blueprintsOutVertex);
                    bindings.put(BlueprintsGraphOutputMapReduce.TITAN_IN_VERTEX, (Object)blueprintsInVertex);
                    bindings.put(BlueprintsGraphOutputMapReduce.GRAPH, (Object)this.graph);
                    bindings.put(BlueprintsGraphOutputMapReduce.MAP_CONTEXT, (Object)context);
                    blueprintsEdge = (Edge)engine.eval(BlueprintsGraphOutputMapReduce.GET_OR_CREATE_EDGE, bindings);
                }
                catch (Exception e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            return blueprintsEdge;
        }
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder<HadoopVertex>, NullWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<Holder<HadoopVertex>> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopElement hadoopVertex = null;
            HashMap hadoopTitanIdMap = new HashMap();
            for (Holder<HadoopVertex> holder : values) {
                if (holder.getTag() == 's') {
                    hadoopTitanIdMap.put(holder.get().getIdAsLong(), holder.get().getProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID));
                    continue;
                }
                HadoopVertex toClone = holder.get();
                hadoopVertex = new HadoopVertex(context.getConfiguration(), toClone.getIdAsLong());
                hadoopVertex.setProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID, toClone.getProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID));
                ((HadoopVertex)hadoopVertex).addEdges(Direction.OUT, toClone);
            }
            if (null != hadoopVertex) {
                hadoopVertex.setProperty(BlueprintsGraphOutputMapReduce.ID_MAP_KEY, hadoopTitanIdMap);
                context.write((Object)NullWritable.get(), (Object)hadoopVertex);
            } else {
                LOGGER.warn((Object)("No source vertex: hadoopVertex[" + key.get() + "]"));
                context.getCounter((Enum)Counters.NULL_VERTICES_IGNORED).increment(1L);
            }
        }
    }

    public static class VertexMap
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder<HadoopVertex>> {
        static GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();
        static boolean firstRead = true;
        Graph graph;
        boolean loadingFromScratch;
        private final Holder<HadoopVertex> vertexHolder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.graph = BlueprintsGraphOutputMapReduce.generateGraph(context.getConfiguration());
            String file = context.getConfiguration().get(BlueprintsGraphOutputMapReduce.TITAN_HADOOP_GRAPH_OUTPUT_BLUEPRINTS_SCRIPT_FILE, null);
            if (null != file && firstRead) {
                FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
                try {
                    engine = new GremlinGroovyScriptEngine();
                    engine.eval((Reader)new InputStreamReader((InputStream)fs.open(new Path(file))));
                    try {
                        engine.eval("getOrCreateVertex(null,null,null)");
                    }
                    catch (ScriptException se) {
                        if (se.getCause().getCause() instanceof MissingMethodException) {
                            engine = null;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                firstRead = false;
            }
            LOGGER.setLevel(Level.INFO);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                Vertex blueprintsVertex = this.getOrCreateVertex(value, context);
                HadoopVertex shellVertex = new HadoopVertex(context.getConfiguration(), value.getIdAsLong());
                shellVertex.setProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID, blueprintsVertex.getId());
                for (Edge hadoopEdge : value.getEdges(Direction.IN)) {
                    this.longWritable.set(((Long)hadoopEdge.getVertex(Direction.OUT).getId()).longValue());
                    context.write((Object)this.longWritable, this.vertexHolder.set('s', shellVertex));
                }
                this.longWritable.set(value.getIdAsLong());
                value.getProperties().clear();
                value.setProperty(BlueprintsGraphOutputMapReduce.BLUEPRINTS_ID, blueprintsVertex.getId());
                value.removeEdges(Tokens.Action.DROP, Direction.IN, new String[0]);
                context.write((Object)this.longWritable, this.vertexHolder.set('v', value));
            }
            catch (Exception e) {
                if (this.graph instanceof TransactionalGraph) {
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                }
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.graph instanceof TransactionalGraph) {
                try {
                    ((TransactionalGraph)this.graph).commit();
                    context.getCounter((Enum)Counters.SUCCESSFUL_TRANSACTIONS).increment(1L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Could not commit transaction during Map.cleanup():", (Throwable)e);
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.graph.shutdown();
        }

        public Vertex getOrCreateVertex(HadoopVertex hadoopVertex, Mapper.Context context) throws InterruptedException {
            Vertex blueprintsVertex;
            if (this.loadingFromScratch) {
                blueprintsVertex = this.graph.addVertex((Object)hadoopVertex.getIdAsLong());
                context.getCounter((Enum)Counters.VERTICES_WRITTEN).increment(1L);
                for (String property : hadoopVertex.getPropertyKeys()) {
                    blueprintsVertex.setProperty(property, hadoopVertex.getProperty(property));
                    context.getCounter((Enum)Counters.VERTEX_PROPERTIES_WRITTEN).increment(1L);
                }
            } else {
                try {
                    Bindings bindings = engine.createBindings();
                    bindings.put(BlueprintsGraphOutputMapReduce.HADOOP_VERTEX, (Object)hadoopVertex);
                    bindings.put(BlueprintsGraphOutputMapReduce.GRAPH, (Object)this.graph);
                    bindings.put(BlueprintsGraphOutputMapReduce.MAP_CONTEXT, (Object)context);
                    blueprintsVertex = (Vertex)engine.eval(BlueprintsGraphOutputMapReduce.GET_OR_CREATE_VERTEX, bindings);
                }
                catch (Exception e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            return blueprintsVertex;
        }
    }

    public static enum Counters {
        VERTICES_RETRIEVED,
        VERTICES_WRITTEN,
        VERTEX_PROPERTIES_WRITTEN,
        EDGES_WRITTEN,
        EDGE_PROPERTIES_WRITTEN,
        NULL_VERTEX_EDGES_IGNORED,
        NULL_VERTICES_IGNORED,
        SUCCESSFUL_TRANSACTIONS,
        FAILED_TRANSACTIONS;

    }
}

