/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class HadoopType {
    public static final HadoopType COUNT = new HadoopType("_count", TypeVisibility.IMPLICIT);
    public static final HadoopType LINK = new HadoopType("_link", TypeVisibility.NORMAL);
    private static final Set<HadoopType> PREDEFINED_TYPES = ImmutableSet.of((Object)COUNT, (Object)LINK);
    private final String name;
    private final TypeVisibility visibility;
    public static final Manager DEFAULT_MANAGER = new Manager();

    public HadoopType(String name) {
        this(HadoopType.checkName(name), TypeVisibility.NORMAL);
    }

    private HadoopType(String name, TypeVisibility visibility) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (String)"Invalid type name: %s", (Object[])new Object[]{name});
        Preconditions.checkNotNull((Object)((Object)visibility));
        this.name = name;
        this.visibility = visibility;
    }

    private static String checkName(String name) {
        return name;
    }

    private static String getHiddenName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        return "_" + name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.visibility == TypeVisibility.HIDDEN || this.visibility == TypeVisibility.IMPLICIT;
    }

    public boolean isImplicit() {
        return this.visibility == TypeVisibility.IMPLICIT;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        return this.name.equals(((HadoopType)other).name);
    }

    public static class VertexSchema
    extends HashMap<HadoopType, Integer> {
        public boolean add(HadoopType type) {
            if (super.containsKey(type)) {
                return false;
            }
            super.put(type, super.size() + 1);
            return true;
        }

        public int getTypeID(HadoopType type) {
            Integer id = (Integer)super.get(type);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)("Type is not part of this schema: " + type));
            return id;
        }
    }

    public static class Manager
    extends HashMap<String, HadoopType> {
        Manager() {
            for (HadoopType type : PREDEFINED_TYPES) {
                super.put(type.getName(), type);
            }
        }

        public final HadoopType get(String name) {
            HadoopType type = (HadoopType)super.get(name);
            if (type == null) {
                type = new HadoopType(name);
                super.put(name, type);
            }
            return type;
        }
    }

    private static enum TypeVisibility {
        NORMAL,
        HIDDEN,
        IMPLICIT;

    }
}

