/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopType;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class HadoopProperty
extends HadoopElement {
    private final HadoopType type;
    private final Object value;

    public HadoopProperty(HadoopType type, Object value) {
        this(0L, type, value);
    }

    public HadoopProperty(long id, String type, Object value) {
        this(id, HadoopType.DEFAULT_MANAGER.get(type), value);
    }

    public HadoopProperty(long id, HadoopType type, Object value) {
        super(id);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)value);
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.type.getName();
    }

    public HadoopType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append(this.value).toHashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        HadoopProperty p = (HadoopProperty)oth;
        return this.type.equals(p.type) && this.value.equals(p.value);
    }

    public String toString() {
        return this.type.toString() + "->" + this.value.toString();
    }

    @Override
    protected void initializeProperties() {
        throw new UnsupportedOperationException();
    }
}

