/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopType;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;

public abstract class HadoopPathElement
extends HadoopElement
implements WritableComparable<HadoopElement>,
Configurable {
    protected List<List<MicroElement>> paths = null;
    protected MicroElement microVersion = null;
    protected boolean trackPaths = false;
    protected long pathCounter = 0L;
    protected Configuration configuration = EmptyConfiguration.immutable();

    public HadoopPathElement(Configuration configuration, long id) {
        super(id);
        this.setConf(configuration);
    }

    @Override
    protected <T> T getImplicitProperty(HadoopType type) {
        if (type.equals(HadoopType.COUNT)) {
            return (T)Long.valueOf(this.pathCount());
        }
        return super.getImplicitProperty(type);
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
        this.trackPaths(configuration.getBoolean("titan.hadoop.pipeline.track-paths", false));
    }

    public Configuration getConf() {
        return this.configuration;
    }

    private void trackPaths(boolean trackPaths) {
        this.trackPaths = trackPaths;
        if (this.trackPaths) {
            if (null == this.microVersion) {
                MicroElement microElement = this.microVersion = this instanceof HadoopVertex ? new HadoopVertex.MicroVertex(this.id) : new HadoopEdge.MicroEdge(this.id);
            }
            if (null == this.paths) {
                this.paths = new ArrayList<List<MicroElement>>();
            }
        }
    }

    public void addPath(List<MicroElement> path, boolean append) throws IllegalStateException {
        if (this.trackPaths) {
            if (append) {
                path.add(this.microVersion);
            }
        } else {
            throw new IllegalStateException("Path calculations are not enabled");
        }
        this.paths.add(path);
    }

    public void addPaths(List<List<MicroElement>> paths, boolean append) throws IllegalStateException {
        if (this.trackPaths) {
            if (append) {
                for (List<MicroElement> path : paths) {
                    this.addPath(path, append);
                }
            } else {
                this.paths.addAll(paths);
            }
        } else {
            throw new IllegalStateException("Path calculations are not enabled");
        }
    }

    public List<List<MicroElement>> getPaths() throws IllegalStateException {
        if (this.trackPaths) {
            return this.paths;
        }
        throw new IllegalStateException("Path calculations are not enabled");
    }

    public void getPaths(HadoopElement element, boolean append) {
        Preconditions.checkArgument((boolean)(element instanceof HadoopPathElement));
        if (this.trackPaths) {
            this.addPaths(((HadoopPathElement)element).getPaths(), append);
        } else {
            this.pathCounter += ((HadoopPathElement)element).pathCount();
        }
    }

    public long incrPath(long amount) throws IllegalStateException {
        if (this.trackPaths) {
            throw new IllegalStateException("Path calculations are enabled -- use addPath()");
        }
        this.pathCounter += amount;
        return this.pathCounter;
    }

    public boolean hasPaths() {
        if (this.trackPaths) {
            return !this.paths.isEmpty();
        }
        return this.pathCounter > 0L;
    }

    public void clearPaths() {
        if (this.trackPaths) {
            this.paths = new ArrayList<List<MicroElement>>();
            this.microVersion = this instanceof HadoopVertex ? new HadoopVertex.MicroVertex(this.id) : new HadoopEdge.MicroEdge(this.id);
        } else {
            this.pathCounter = 0L;
        }
    }

    public long pathCount() {
        if (this.trackPaths) {
            return this.paths.size();
        }
        return this.pathCounter;
    }

    public void startPath() {
        if (this.trackPaths) {
            this.clearPaths();
            ArrayList<MicroElement> startPath = new ArrayList<MicroElement>();
            startPath.add(this.microVersion);
            this.paths.add(startPath);
        } else {
            this.pathCounter = 1L;
        }
    }

    public static abstract class MicroElement {
        protected final long id;

        public MicroElement(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public int hashCode() {
            return Long.valueOf(this.id).hashCode();
        }

        public boolean equals(Object object) {
            return object.getClass().equals(this.getClass()) && this.id == ((MicroElement)object).getId();
        }
    }
}

