/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.hadoop.formats.Inverter;
import com.thinkaurelius.titan.hadoop.hdfs.HDFSTools;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;

public class HadoopGraph
implements Configurable {
    public static final String TITAN_HADOOP_GRAPH_INPUT_FORMAT = "titan.hadoop.graph.input.format";
    public static final String TITAN_HADOOP_INPUT_LOCATION = "titan.hadoop.input.location";
    public static final String TITAN_HADOOP_GRAPH_OUTPUT_FORMAT = "titan.hadoop.graph.output.format";
    public static final String TITAN_HADOOP_SIDEEFFECT_OUTPUT_FORMAT = "titan.hadoop.sideeffect.output.format";
    public static final String TITAN_HADOOP_OUTPUT_LOCATION = "titan.hadoop.output.location";
    public static final String TITAN_HADOOP_OUTPUT_LOCATION_OVERWRITE = "titan.hadoop.output.location.overwrite";
    private Configuration configuration;

    public HadoopGraph() {
        this(new Configuration());
    }

    public HadoopGraph(Configuration configuration) {
        this.configuration = new Configuration(configuration);
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public Configuration getConf(String prefix) {
        EmptyConfiguration prefixConf = new EmptyConfiguration();
        for (Map.Entry entry : this.configuration) {
            if (!((String)entry.getKey()).startsWith(prefix + ".")) continue;
            prefixConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return prefixConf;
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
    }

    public Class<? extends InputFormat> getGraphInputFormat() {
        return this.configuration.getClass(TITAN_HADOOP_GRAPH_INPUT_FORMAT, InputFormat.class, InputFormat.class);
    }

    public void setGraphInputFormat(Class<? extends InputFormat> format) {
        this.configuration.setClass(TITAN_HADOOP_GRAPH_INPUT_FORMAT, format, InputFormat.class);
    }

    public Class<? extends OutputFormat> getGraphOutputFormat() {
        return this.configuration.getClass(TITAN_HADOOP_GRAPH_OUTPUT_FORMAT, OutputFormat.class, OutputFormat.class);
    }

    public void setGraphOutputFormat(Class<? extends OutputFormat> format) {
        this.configuration.setClass(TITAN_HADOOP_GRAPH_OUTPUT_FORMAT, format, OutputFormat.class);
    }

    public Class<? extends OutputFormat> getSideEffectOutputFormat() {
        return this.configuration.getClass(TITAN_HADOOP_SIDEEFFECT_OUTPUT_FORMAT, OutputFormat.class, OutputFormat.class);
    }

    public void setSideEffectOutputFormat(Class<? extends OutputFormat> format) {
        this.configuration.setClass(TITAN_HADOOP_SIDEEFFECT_OUTPUT_FORMAT, format, OutputFormat.class);
    }

    public Path getInputLocation() {
        if (null == this.configuration.get(TITAN_HADOOP_INPUT_LOCATION)) {
            return null;
        }
        return new Path(this.configuration.get(TITAN_HADOOP_INPUT_LOCATION));
    }

    public void setInputLocation(Path path) {
        this.configuration.set(TITAN_HADOOP_INPUT_LOCATION, path.toString());
    }

    public void setInputLocation(String path) {
        this.setInputLocation(new Path(path));
    }

    public Path getOutputLocation() {
        if (null == this.configuration.get(TITAN_HADOOP_OUTPUT_LOCATION)) {
            throw new IllegalStateException("Please set titan.hadoop.output.location configuration option.");
        }
        return new Path(this.configuration.get(TITAN_HADOOP_OUTPUT_LOCATION));
    }

    public void setOutputLocation(Path path) {
        this.configuration.set(TITAN_HADOOP_OUTPUT_LOCATION, path.toString());
    }

    public void setOutputLocation(String path) {
        this.setOutputLocation(new Path(path));
    }

    public boolean getOutputLocationOverwrite() {
        return this.configuration.getBoolean(TITAN_HADOOP_OUTPUT_LOCATION_OVERWRITE, false);
    }

    public void setOutputLocationOverwrite(boolean overwrite) {
        this.configuration.setBoolean(TITAN_HADOOP_OUTPUT_LOCATION_OVERWRITE, overwrite);
    }

    public void setTrackPaths(boolean trackPaths) {
        this.configuration.setBoolean("titan.hadoop.pipeline.track-paths", trackPaths);
    }

    public boolean getTrackPaths() {
        return this.configuration.getBoolean("titan.hadoop.pipeline.track-paths", false);
    }

    public void setTrackState(boolean trackState) {
        this.configuration.setBoolean("titan.hadoop.pipeline.track-state", trackState);
    }

    public boolean getTrackState() {
        return this.configuration.getBoolean("titan.hadoop.pipeline.track-state", false);
    }

    public void shutdown() {
        this.configuration.clear();
    }

    public String toString() {
        return "titangraph[hadoop:" + this.configuration.getClass(TITAN_HADOOP_GRAPH_INPUT_FORMAT, InputFormat.class).getSimpleName().toLowerCase() + "->" + this.configuration.getClass(TITAN_HADOOP_GRAPH_OUTPUT_FORMAT, OutputFormat.class).getSimpleName().toLowerCase() + "]";
    }

    public HadoopGraph getNextGraph() throws IOException {
        HadoopGraph graph = new HadoopGraph(this.getConf());
        if (null != this.getGraphOutputFormat()) {
            graph.setGraphInputFormat(Inverter.invertOutputFormat(this.getGraphOutputFormat()));
        }
        if (null != this.getOutputLocation()) {
            graph.setInputLocation(HDFSTools.getOutputsFinalJob(FileSystem.get((Configuration)this.configuration), this.getOutputLocation().toString()));
            graph.setOutputLocation(new Path(this.getOutputLocation().toString() + "_"));
        }
        return graph;
    }
}

