/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopSerializer;
import com.thinkaurelius.titan.hadoop.HadoopType;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;

public class HadoopEdge
extends HadoopPathElement
implements Edge {
    protected long outVertex;
    protected long inVertex;
    private HadoopType label;

    public HadoopEdge() {
        this(EmptyConfiguration.immutable());
    }

    public HadoopEdge(Configuration configuration) {
        super(configuration, -1L);
        this.label = HadoopType.LINK;
    }

    public HadoopEdge(Configuration configuration, DataInput in) throws IOException {
        super(configuration, -1L);
        this.readFields(in);
    }

    public HadoopEdge(Configuration configuration, long outVertex, long inVertex, String label) {
        this(configuration, -1L, outVertex, inVertex, label);
    }

    public HadoopEdge(Configuration configuration, long id, long outVertex, long inVertex, String label) {
        super(configuration, id);
        this.outVertex = outVertex;
        this.inVertex = inVertex;
        this.setLabel(label);
    }

    @Override
    void updateSchema(HadoopSerializer.Schema schema) {
        super.updateSchema(schema);
        schema.add(this.label);
    }

    public Vertex getVertex(Direction direction) {
        if (Direction.OUT.equals((Object)direction)) {
            return new HadoopVertex(this.configuration, this.outVertex);
        }
        if (Direction.IN.equals((Object)direction)) {
            return new HadoopVertex(this.configuration, this.inVertex);
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public long getVertexId(Direction direction) {
        if (Direction.OUT.equals((Object)direction)) {
            return this.outVertex;
        }
        if (Direction.IN.equals((Object)direction)) {
            return this.inVertex;
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public String getLabel() {
        return this.label.getName();
    }

    public HadoopType getType() {
        return this.label;
    }

    final void setLabel(HadoopType label) {
        Preconditions.checkNotNull((Object)label);
        this.label = label;
    }

    final void setLabel(String label) {
        this.setLabel(HadoopType.DEFAULT_MANAGER.get(label));
    }

    public void write(DataOutput out) throws IOException {
        new HadoopSerializer(this.getConf()).writeEdge(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        new HadoopSerializer(this.getConf()).readEdge(this, in);
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public static class MicroEdge
    extends HadoopPathElement.MicroElement {
        private static final String E1 = "e[";
        private static final String E2 = "]";

        public MicroEdge(long id) {
            super(id);
        }

        public String toString() {
            return E1 + this.id + E2;
        }
    }
}

