/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.sail.impls;

import com.tinkerpop.blueprints.impls.sail.SailGraph;
import java.util.LinkedList;
import net.fortytwo.sesametools.reposail.RepositorySail;
import org.openrdf.repository.Repository;
import org.openrdf.repository.sparql.SPARQLRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.sail.Sail;

public class SparqlRepositorySailGraph
extends SailGraph {
    public SparqlRepositorySailGraph(String queryEndpointUrl) {
        super(SparqlRepositorySailGraph.createSail(queryEndpointUrl, null));
    }

    public SparqlRepositorySailGraph(String queryEndpointUrl, String updateEndpointUrl) {
        super(SparqlRepositorySailGraph.createSail(queryEndpointUrl, updateEndpointUrl));
    }

    private static Sail createSail(String queryEndpointUrl, String updateEndpointUrl) {
        if (null == queryEndpointUrl) {
            throw new IllegalArgumentException("Query endpoint URL may not be null");
        }
        SPARQLRepository r = null == updateEndpointUrl ? new SPARQLRepository(queryEndpointUrl) : new SPARQLRepository(queryEndpointUrl, updateEndpointUrl);
        return new RepositorySail((Repository)r);
    }

    private static void ignoreDatatypesInAllParsers() {
        RDFParserRegistry r = RDFParserRegistry.getInstance();
        LinkedList<RDFParserFactory> oldFactories = new LinkedList<RDFParserFactory>();
        LinkedList<1> newFactories = new LinkedList<1>();
        for (final RDFFormat rDFFormat : r.getKeys()) {
            final RDFParserFactory pf = (RDFParserFactory)r.get((Object)rDFFormat);
            pf.getParser().setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFParserFactory pfn = new RDFParserFactory(){

                public RDFFormat getRDFFormat() {
                    return rDFFormat;
                }

                public RDFParser getParser() {
                    RDFParser p = pf.getParser();
                    p.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                    return p;
                }
            };
            oldFactories.add(pf);
            newFactories.add(pfn);
        }
        for (RDFParserFactory rDFParserFactory : oldFactories) {
            r.remove((Object)rDFParserFactory);
        }
        for (RDFParserFactory rDFParserFactory : newFactories) {
            r.add((Object)rDFParserFactory);
        }
    }

    static {
        try {
            SparqlRepositorySailGraph.ignoreDatatypesInAllParsers();
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }
}

