/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.sail;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.sail.SailEdge;
import com.tinkerpop.blueprints.impls.sail.SailGraph;
import info.aduna.iteration.CloseableIteration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailException;

class SailEdgeIterable
implements Iterable<Edge> {
    private final SailGraph graph;
    private final Resource subject;
    private final URI predicate;
    private final Value object;

    public SailEdgeIterable(Resource subject, URI predicate, Value object, SailGraph graph) {
        this.subject = subject;
        this.object = object;
        this.predicate = predicate;
        this.graph = graph;
    }

    @Override
    public Iterator<Edge> iterator() {
        return new SailEdgeIterator();
    }

    private class SailEdgeIterator
    implements Iterator<Edge> {
        private final CloseableIteration<? extends Statement, SailException> statements;

        public SailEdgeIterator() {
            try {
                this.statements = SailEdgeIterable.this.graph.getSailConnection().get().getStatements(SailEdgeIterable.this.subject, SailEdgeIterable.this.predicate, SailEdgeIterable.this.object, false, new Resource[0]);
            }
            catch (SailException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.statements.hasNext()) {
                    return true;
                }
                this.statements.close();
                return false;
            }
            catch (SailException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Edge next() {
            try {
                return new SailEdge((Statement)this.statements.next(), SailEdgeIterable.this.graph);
            }
            catch (SailException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (NoSuchElementException e) {
                try {
                    this.statements.close();
                }
                catch (SailException e2) {
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                throw e;
            }
        }
    }
}

