/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Precision;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.es.ElasticSearchConstants;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.util.DefaultTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class ElasticSearchIndex
implements IndexProvider {
    private Logger log = LoggerFactory.getLogger(ElasticSearchIndex.class);
    private static final String[] DATA_SUBDIRS = new String[]{"data", "work", "logs"};
    public static final ConfigOption<Integer> MAX_RESULT_SET_SIZE = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "max-result-set-size", "Maxium number of results to return if no limit is specified", ConfigOption.Type.MASKABLE, (Object)100000);
    public static final ConfigOption<Boolean> CLIENT_ONLY = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "client-only", "Whether Titan connects to the indexing backend as a client", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<String> CLUSTER_NAME = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "cluster-name", "The name of the indexing backend cluster", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"elasticsearch");
    public static final ConfigOption<Boolean> LOCAL_MODE = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "local-mode", "Whether a full indexing instances is started embedded", ConfigOption.Type.GLOBAL_OFFLINE, (Object)false);
    public static final ConfigOption<Boolean> CLIENT_SNIFF = new ConfigOption(GraphDatabaseConfiguration.INDEX_NS, "sniff", "Whether to enable cluster sniffing", ConfigOption.Type.MASKABLE, (Object)true);
    public static final int HOST_PORT_DEFAULT = 9300;
    private final Node node;
    private final Client client;
    private final String indexName;
    private final int maxResultsSize;

    public ElasticSearchIndex(Configuration config) {
        this.indexName = (String)config.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        this.checkExpectedClientVersion();
        if (((Boolean)config.get(LOCAL_MODE, new String[0])).booleanValue()) {
            this.log.debug("Configuring ES for JVM local transport");
            boolean clientOnly = (Boolean)config.get(CLIENT_ONLY, new String[0]);
            boolean local = (Boolean)config.get(LOCAL_MODE, new String[0]);
            NodeBuilder builder = NodeBuilder.nodeBuilder();
            Preconditions.checkArgument((config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]) || config.has(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]) ? 1 : 0) != 0, (Object)"Must either configure configuration file or base directory");
            if (config.has(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0])) {
                String configFile = (String)config.get(GraphDatabaseConfiguration.INDEX_CONF_FILE, new String[0]);
                this.log.debug("Configuring ES from YML file [{}]", (Object)configFile);
                Settings settings = ImmutableSettings.settingsBuilder().loadFromSource(configFile).build();
                builder.settings(settings);
            } else {
                String dataDirectory = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
                this.log.debug("Configuring ES with data directory [{}]", (Object)dataDirectory);
                File f = new File(dataDirectory);
                if (!f.exists()) {
                    f.mkdirs();
                }
                ImmutableSettings.Builder b = ImmutableSettings.settingsBuilder();
                for (String sub : DATA_SUBDIRS) {
                    String subdir = dataDirectory + File.separator + sub;
                    f = new File(subdir);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    b.put("path." + sub, subdir);
                }
                builder.settings(b.build());
                String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                builder.clusterName(clustername);
            }
            this.node = builder.client(clientOnly).data(!clientOnly).local(local).node();
            this.client = this.node.client();
        } else {
            this.log.debug("Configuring ES for network transport");
            ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
            if (config.has(CLUSTER_NAME, new String[0])) {
                String clustername = (String)config.get(CLUSTER_NAME, new String[0]);
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)clustername), (String)"Invalid cluster name: %s", (Object[])new Object[]{clustername});
                settings.put("cluster.name", clustername);
            } else {
                settings.put("client.transport.ignore_cluster_name", true);
            }
            this.log.debug("Transport sniffing enabled: {}", config.get(CLIENT_SNIFF, new String[0]));
            settings.put("client.transport.sniff", ((Boolean)config.get(CLIENT_SNIFF, new String[0])).booleanValue());
            TransportClient tc = new TransportClient(settings.build());
            int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? (Integer)config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9300;
            for (String host : (String[])config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
                String[] hostparts = host.split(":");
                String hostname = hostparts[0];
                int hostport = defaultPort;
                if (hostparts.length == 2) {
                    hostport = Integer.parseInt(hostparts[1]);
                }
                this.log.info("Configured remote host: {} : {}", (Object)hostname, (Object)hostport);
                tc.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, hostport));
            }
            this.client = tc;
            this.node = null;
        }
        this.maxResultsSize = (Integer)config.get(MAX_RESULT_SET_SIZE, new String[0]);
        this.log.debug("Configured ES query result set max size to {}", (Object)this.maxResultsSize);
        this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet();
        IndicesExistsResponse response = (IndicesExistsResponse)this.client.admin().indices().exists(new IndicesExistsRequest(new String[]{this.indexName})).actionGet();
        if (!response.isExists()) {
            CreateIndexResponse create = (CreateIndexResponse)this.client.admin().indices().prepareCreate(this.indexName).execute().actionGet();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new TitanException("Interrupted while waiting for index to settle in", (Throwable)e);
            }
            if (!create.isAcknowledged()) {
                throw new IllegalArgumentException("Could not create index: " + this.indexName);
            }
        }
    }

    private StorageException convert(Exception esException) {
        if (esException instanceof InterruptedException) {
            return new TemporaryStorageException("Interrupted while waiting for response", (Throwable)esException);
        }
        return new PermanentStorageException("Unknown exception while executing index operation", (Throwable)esException);
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws StorageException {
        XContentBuilder mapping = null;
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
        try {
            mapping = XContentFactory.jsonBuilder().startObject().startObject(store).startObject("properties").startObject(key);
            if (AttributeUtil.isString((Class)dataType)) {
                this.log.debug("Registering string type for {}", (Object)key);
                mapping.field("type", "string");
                if (map == Mapping.STRING) {
                    mapping.field("index", "not_analyzed");
                }
            } else if (dataType == Float.class) {
                this.log.debug("Registering float type for {}", (Object)key);
                mapping.field("type", "float");
            } else if (dataType == Double.class || dataType == Decimal.class || dataType == Precision.class) {
                this.log.debug("Registering double type for {}", (Object)key);
                mapping.field("type", "double");
            } else if (dataType == Byte.class) {
                this.log.debug("Registering byte type for {}", (Object)key);
                mapping.field("type", "byte");
            } else if (dataType == Short.class) {
                this.log.debug("Registering short type for {}", (Object)key);
                mapping.field("type", "short");
            } else if (dataType == Integer.class) {
                this.log.debug("Registering integer type for {}", (Object)key);
                mapping.field("type", "integer");
            } else if (dataType == Long.class) {
                this.log.debug("Registering long type for {}", (Object)key);
                mapping.field("type", "long");
            } else if (dataType == Boolean.class) {
                this.log.debug("Registering boolean type for {}", (Object)key);
                mapping.field("type", "boolean");
            } else if (dataType == Geoshape.class) {
                this.log.debug("Registering geo_point type for {}", (Object)key);
                mapping.field("type", "geo_point");
            }
            mapping.endObject().endObject().endObject().endObject();
        }
        catch (IOException e) {
            throw new PermanentStorageException("Could not render json for put mapping request", (Throwable)e);
        }
        try {
            PutMappingResponse response = (PutMappingResponse)this.client.admin().indices().preparePutMapping(new String[]{this.indexName}).setIgnoreConflicts(false).setType(store).setSource(mapping).execute().actionGet();
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public XContentBuilder getContent(List<IndexEntry> additions) throws StorageException {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            for (IndexEntry add : additions) {
                if (add.value instanceof Number) {
                    if (AttributeUtil.isWholeNumber((Number)((Number)add.value))) {
                        builder.field(add.field, ((Number)add.value).longValue());
                        continue;
                    }
                    builder.field(add.field, ((Number)add.value).doubleValue());
                    continue;
                }
                if (AttributeUtil.isString((Object)add.value)) {
                    builder.field(add.field, (String)add.value);
                    continue;
                }
                if (add.value instanceof Geoshape) {
                    Geoshape shape = (Geoshape)add.value;
                    if (shape.getType() == Geoshape.Type.POINT) {
                        Geoshape.Point p = shape.getPoint();
                        builder.field(add.field, new double[]{p.getLongitude(), p.getLatitude()});
                        continue;
                    }
                    throw new UnsupportedOperationException("Geo type is not supported: " + shape.getType());
                }
                throw new IllegalArgumentException("Unsupported type: " + add.value);
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new PermanentStorageException("Could not write json");
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        BulkRequestBuilder brb = this.client.prepareBulk();
        int bulkrequests = 0;
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String storename = stores.getKey();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docid = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    assert (mutation.isConsolidated());
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            this.log.trace("Deleting entire document {}", (Object)docid);
                            brb.add(new DeleteRequest(this.indexName, storename, docid));
                            ++bulkrequests;
                        } else {
                            StringBuilder script = new StringBuilder();
                            for (String key : Iterables.transform((Iterable)mutation.getDeletions(), (Function)IndexMutation.ENTRY2FIELD_FCT)) {
                                script.append("ctx._source.remove(\"" + key + "\"); ");
                                this.log.trace("Deleting individual field [{}] for document {}", (Object)key, (Object)docid);
                            }
                            brb.add(this.client.prepareUpdate(this.indexName, storename, docid).setScript(script.toString()));
                        }
                    }
                    if (!mutation.hasAdditions()) continue;
                    if (mutation.isNew()) {
                        this.log.trace("Adding entire document {}", (Object)docid);
                        brb.add(new IndexRequest(this.indexName, storename, docid).source(this.getContent(mutation.getAdditions())));
                        ++bulkrequests;
                        continue;
                    }
                    boolean needUpsert = !mutation.hasDeletions();
                    XContentBuilder builder = this.getContent(mutation.getAdditions());
                    UpdateRequestBuilder update = this.client.prepareUpdate(this.indexName, storename, docid).setDoc(builder);
                    if (needUpsert) {
                        update.setUpsert(builder);
                    }
                    this.log.trace("Updating document {} with upsert {}", (Object)docid, (Object)needUpsert);
                    brb.add(update);
                }
            }
            if (bulkrequests > 0) {
                brb.execute().actionGet();
            }
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    public FilterBuilder getFilter(Condition<?> condition, KeyInformation.StoreRetriever informations) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Cmp numRel = (Cmp)titanPredicate;
                Preconditions.checkArgument((boolean)(value instanceof Number));
                switch (numRel) {
                    case EQUAL: {
                        return FilterBuilders.inFilter((String)key, (Object[])new Object[]{value});
                    }
                    case NOT_EQUAL: {
                        return FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value}));
                    }
                    case LESS_THAN: {
                        return FilterBuilders.rangeFilter((String)key).lt(value);
                    }
                    case LESS_THAN_EQUAL: {
                        return FilterBuilders.rangeFilter((String)key).lte(value);
                    }
                    case GREATER_THAN: {
                        return FilterBuilders.rangeFilter((String)key).gt(value);
                    }
                    case GREATER_THAN_EQUAL: {
                        return FilterBuilders.rangeFilter((String)key).gte(value);
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                Mapping map = Mapping.getMapping((KeyInformation)informations.get(key));
                if (!(map != Mapping.DEFAULT && map != Mapping.TEXT || titanPredicate.toString().startsWith("CONTAINS"))) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (titanPredicate == Text.CONTAINS) {
                    value = ((String)value).toLowerCase();
                    return FilterBuilders.termFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Text.CONTAINS_PREFIX) {
                    value = ((String)value).toLowerCase();
                    return FilterBuilders.prefixFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Text.CONTAINS_REGEX) {
                    value = ((String)value).toLowerCase();
                    return FilterBuilders.regexpFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Text.PREFIX) {
                    return FilterBuilders.prefixFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Text.REGEX) {
                    return FilterBuilders.regexpFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Cmp.EQUAL) {
                    return FilterBuilders.termFilter((String)key, (String)((String)value));
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    return FilterBuilders.notFilter((FilterBuilder)FilterBuilders.termFilter((String)key, (String)((String)value)));
                }
                throw new IllegalArgumentException("Predicate is not supported for string value: " + titanPredicate);
            }
            if (value instanceof Geoshape) {
                Preconditions.checkArgument((titanPredicate == Geo.WITHIN ? 1 : 0) != 0, (Object)("Relation is not supported for geo value: " + titanPredicate));
                Geoshape shape = (Geoshape)value;
                if (shape.getType() == Geoshape.Type.CIRCLE) {
                    Geoshape.Point center = shape.getPoint();
                    return FilterBuilders.geoDistanceFilter((String)key).lat((double)center.getLatitude()).lon((double)center.getLongitude()).distance((double)shape.getRadius(), DistanceUnit.KILOMETERS);
                }
                if (shape.getType() == Geoshape.Type.BOX) {
                    Geoshape.Point southwest = shape.getPoint(0);
                    Geoshape.Point northeast = shape.getPoint(1);
                    return FilterBuilders.geoBoundingBoxFilter((String)key).bottomRight((double)southwest.getLatitude(), (double)northeast.getLongitude()).topLeft((double)northeast.getLatitude(), (double)southwest.getLongitude());
                }
                throw new IllegalArgumentException("Unsupported or invalid search shape type: " + shape.getType());
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            return FilterBuilders.notFilter((FilterBuilder)this.getFilter(((Not)condition).getChild(), informations));
        }
        if (condition instanceof And) {
            AndFilterBuilder b = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
            for (Condition c : condition.getChildren()) {
                b.add(this.getFilter(c, informations));
            }
            return b;
        }
        if (condition instanceof Or) {
            OrFilterBuilder b = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
            for (Condition c : condition.getChildren()) {
                b.add(this.getFilter(c, informations));
            }
            return b;
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        srb.setPostFilter(this.getFilter(query.getCondition(), informations.get(query.getStore())));
        if (!query.getOrder().isEmpty()) {
            List orders = query.getOrder();
            for (int i = 0; i < orders.size(); ++i) {
                srb.addSort((SortBuilder)new FieldSortBuilder(((IndexQuery.OrderEntry)orders.get(i)).getKey()).order(((IndexQuery.OrderEntry)orders.get(i)).getOrder() == Order.ASC ? SortOrder.ASC : SortOrder.DESC).ignoreUnmapped(true));
            }
        }
        srb.setFrom(0);
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        this.log.debug("Executed query [{}] in {} ms", (Object)query.getCondition(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            this.log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<String> result = new ArrayList<String>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add(hit.id());
        }
        return result;
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        SearchRequestBuilder srb = this.client.prepareSearch(new String[]{this.indexName});
        srb.setTypes(new String[]{query.getStore()});
        srb.setQuery((QueryBuilder)QueryBuilders.queryString((String)query.getQuery()));
        srb.setFrom(query.getOffset());
        if (query.hasLimit()) {
            srb.setSize(query.getLimit());
        } else {
            srb.setSize(this.maxResultsSize);
        }
        srb.setNoFields();
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        this.log.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getTookInMillis());
        SearchHits hits = response.getHits();
        if (!query.hasLimit() && hits.totalHits() >= (long)this.maxResultsSize) {
            this.log.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResultsSize, (Object)query);
        }
        ArrayList<RawQuery.Result<String>> result = new ArrayList<RawQuery.Result<String>>(hits.hits().length);
        for (SearchHit hit : hits) {
            result.add((RawQuery.Result<String>)new RawQuery.Result((Object)hit.id(), (double)hit.getScore()));
        }
        return result;
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (mapping != Mapping.DEFAULT && !AttributeUtil.isString((Class)dataType)) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else {
            if (dataType == Geoshape.class) {
                return titanPredicate == Geo.WITHIN;
            }
            if (AttributeUtil.isString((Class)dataType)) {
                switch (mapping) {
                    case DEFAULT: 
                    case TEXT: {
                        return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX || titanPredicate == Text.CONTAINS_REGEX;
                    }
                    case STRING: {
                        return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.REGEX || titanPredicate == Text.PREFIX;
                    }
                }
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Geoshape.class ? mapping == Mapping.DEFAULT : AttributeUtil.isString((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT);
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws StorageException {
        return new DefaultTransaction(config);
    }

    public void close() throws StorageException {
        this.client.close();
        if (this.node != null && !this.node.isClosed()) {
            this.node.close();
        }
    }

    public void clearStorage() throws StorageException {
        try {
            try {
                this.client.admin().indices().delete(new DeleteIndexRequest(this.indexName)).actionGet();
                Thread.sleep(1000L);
            }
            catch (IndexMissingException e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new PermanentStorageException("Could not delete index " + this.indexName, (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    private void checkExpectedClientVersion() {
        if (!Version.CURRENT.equals((Object)ElasticSearchConstants.ES_VERSION_EXPECTED)) {
            this.log.warn("ES client version {} does not match the version with which Titan was compiled {}.  This might cause problems.", (Object)Version.CURRENT, (Object)ElasticSearchConstants.ES_VERSION_EXPECTED);
        } else {
            this.log.debug("Found expected ES client version: {} (OK)", (Object)Version.CURRENT);
        }
    }
}

