/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.es;

import com.thinkaurelius.titan.core.TitanFactory;
import java.io.IOException;
import java.util.Properties;
import org.elasticsearch.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchConstants {
    public static final String ES_PROPERTIES_FILE = "titan-es.properties";
    public static final Version ES_VERSION_EXPECTED;
    private static final Logger log;

    private static Version getExpectedVersionReflectively(String fieldName) {
        String msg = "Failed to load expected ES version";
        try {
            return (Version)Version.class.getField(fieldName).get(null);
        }
        catch (NoSuchFieldException e) {
            log.error("Failed to load expected ES version", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            log.error("Failed to load expected ES version", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to load expected ES version", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to load expected ES version", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        Properties props;
        log = LoggerFactory.getLogger(ElasticSearchConstants.class);
        try {
            props = new Properties();
            props.load(TitanFactory.class.getClassLoader().getResourceAsStream(ES_PROPERTIES_FILE));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        String vs = props.getProperty("es.version");
        String versionConstantName = String.format("V_%s_%s_%s", vs.split("\\."));
        ES_VERSION_EXPECTED = ElasticSearchConstants.getExpectedVersionReflectively(versionConstantName);
    }
}

