/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ClassLibrary
implements Serializable {
    private final Set classNames = new TreeSet();
    private final Map classNameToClassMap = new HashMap();
    private boolean defaultClassLoadersAdded = false;
    private transient List classLoaders = new ArrayList();

    public ClassLibrary() {
    }

    public ClassLibrary(ClassLoader loader) {
        this.classLoaders.add(loader);
    }

    public void add(String className) {
        this.classNames.add(className);
    }

    public boolean contains(String className) {
        if (this.classNames.contains(className)) {
            return true;
        }
        return this.getClass(className) != null;
    }

    public Class getClass(String className) {
        Class cachedClass = (Class)this.classNameToClassMap.get(className);
        if (cachedClass != null) {
            return cachedClass;
        }
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            if (classLoader == null) continue;
            try {
                Class<?> clazz = classLoader.loadClass(className);
                if (clazz == null) continue;
                this.classNameToClassMap.put(className, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
            }
        }
        return null;
    }

    public Collection all() {
        return Collections.unmodifiableCollection(this.classNames);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addDefaultLoader() {
        if (!this.defaultClassLoadersAdded) {
            this.classLoaders.add(this.getClass().getClassLoader());
            this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        this.defaultClassLoadersAdded = true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.classLoaders = new ArrayList();
        if (this.defaultClassLoadersAdded) {
            this.defaultClassLoadersAdded = false;
            this.addDefaultLoader();
        }
    }
}

