/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.javahandler;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerException;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

class JavaHandlerContextImpl<C extends Element>
implements JavaHandlerContext<C> {
    private final FramedGraph<?> graph;
    private final Method method;
    private final C context;

    JavaHandlerContextImpl(FramedGraph<?> graph, Method method, C context) {
        this.graph = graph;
        this.method = method;
        this.context = context;
    }

    @Override
    public FramedGraph<?> g() {
        return this.graph;
    }

    @Override
    public C it() {
        return this.context;
    }

    @Override
    public <E> GremlinPipeline<C, E> gremlin() {
        return new GremlinPipeline(this.it());
    }

    @Override
    public <E> GremlinPipeline<C, E> gremlin(Object starts) {
        return new GremlinPipeline(starts);
    }

    @Override
    public <T> T frame(Vertex vertex) {
        return (T)this.g().frame(vertex, this.method.getReturnType());
    }

    @Override
    public <T> T frame(Vertex vertex, Class<T> kind) {
        return this.g().frame(vertex, kind);
    }

    @Override
    public <T> T frame(Edge edge, Direction direction) {
        return (T)this.g().frame(edge, direction, this.method.getReturnType());
    }

    @Override
    public <T> T frame(Edge edge, Direction direction, Class<T> kind) {
        return this.g().frame(edge, direction, kind);
    }

    @Override
    public <T> Iterable<T> frameVertices(Iterable<Vertex> vertices) {
        Type type = this.getIterableType();
        return this.g().frameVertices(vertices, (Class)type);
    }

    @Override
    public <T> Iterable<T> frameVertices(Iterable<Vertex> vertices, Class<T> kind) {
        return this.g().frameVertices(vertices, kind);
    }

    @Override
    public <T> Iterable<T> frameEdges(Iterable<Edge> edges, Direction direction) {
        Type type = this.getIterableType();
        return this.g().frameEdges(edges, direction, (Class)type);
    }

    @Override
    public <T> Iterable<T> frameEdges(Iterable<Edge> edges, Direction direction, Class<T> kind) {
        return this.g().frameEdges(edges, direction, kind);
    }

    private Type getIterableType() {
        if (this.method.getReturnType() != Iterable.class) {
            throw new JavaHandlerException("Method return type is not iterable: " + this.method);
        }
        Type genericReturnType = this.method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw new JavaHandlerException("Method must specify generic parameter for Iterable: " + this.method);
        }
        return ClassUtilities.getGenericClass(this.method);
    }

    @Override
    public <T> T frame(Edge edge) {
        return (T)this.g().frame(edge, this.method.getReturnType());
    }

    @Override
    public <T> T frame(Edge edge, Class<T> kind) {
        return this.g().frame(edge, kind);
    }

    @Override
    public <T> Iterable<T> frameEdges(Iterable<Edge> edges) {
        Type type = this.getIterableType();
        return this.g().frameEdges(edges, (Class)type);
    }

    @Override
    public <T> Iterable<T> frameEdges(Iterable<Edge> edges, Class<T> kind) {
        return this.g().frameEdges(edges, kind);
    }
}

