/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.annotations;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.ClassUtilities;
import com.tinkerpop.frames.EdgeFrame;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.Incidence;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.annotations.AnnotationHandler;
import com.tinkerpop.frames.structures.FramedEdgeIterable;
import java.lang.reflect.Method;

public class IncidenceAnnotationHandler
implements AnnotationHandler<Incidence> {
    @Override
    public Class<Incidence> getAnnotationType() {
        return Incidence.class;
    }

    @Override
    public Object processElement(Incidence annotation, Method method, Object[] arguments, FramedGraph framedGraph, Element element, Direction direction) {
        if (element instanceof Vertex) {
            return this.processVertex(annotation, method, arguments, framedGraph, (Vertex)element);
        }
        throw new UnsupportedOperationException();
    }

    public Object processVertex(Incidence incidence, Method method, Object[] arguments, FramedGraph framedGraph, Vertex element) {
        if (ClassUtilities.isGetMethod(method)) {
            return new FramedEdgeIterable(framedGraph, element.getEdges(incidence.direction(), new String[]{incidence.label()}), incidence.direction(), ClassUtilities.getGenericClass(method));
        }
        if (ClassUtilities.isAddMethod(method)) {
            switch (incidence.direction()) {
                case OUT: {
                    return framedGraph.addEdge(null, element, ((VertexFrame)arguments[0]).asVertex(), incidence.label(), Direction.OUT, method.getReturnType());
                }
                case IN: {
                    return framedGraph.addEdge(null, ((VertexFrame)arguments[0]).asVertex(), element, incidence.label(), Direction.IN, method.getReturnType());
                }
                case BOTH: {
                    throw new UnsupportedOperationException("Direction.BOTH it not supported on 'add' or 'set' methods");
                }
            }
        } else if (ClassUtilities.isRemoveMethod(method)) {
            framedGraph.removeEdge(((EdgeFrame)arguments[0]).asEdge());
            return null;
        }
        return null;
    }
}

