/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.RetryPolicy;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RetryNTimes
implements RetryPolicy {
    private final int max;
    private int attempts;

    public RetryNTimes(int max) {
        this.max = max;
        this.attempts = 0;
    }

    @Override
    public void begin() {
        this.attempts = 0;
    }

    @Override
    public void success() {
    }

    @Override
    public void failure(Exception e) {
    }

    @Override
    public boolean allowRetry() {
        if (this.max == -1 || this.attempts < this.max) {
            ++this.attempts;
            return true;
        }
        return false;
    }

    @Override
    public int getAttemptCount() {
        return this.attempts;
    }

    @Override
    public RetryPolicy duplicate() {
        return new RetryNTimes(this.max);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

