/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.retry.SleepingRetryPolicy;
import java.util.Random;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ExponentialBackoff
extends SleepingRetryPolicy {
    private final Random random = new Random();
    private final int baseSleepTimeMs;

    public ExponentialBackoff(int baseSleepTimeMs, int maxAttempts) {
        super(maxAttempts);
        this.baseSleepTimeMs = baseSleepTimeMs;
    }

    @Override
    public long getSleepTimeMs() {
        return this.baseSleepTimeMs * Math.max(1, this.random.nextInt(1 << this.getAttemptCount() + 1));
    }

    public int getBaseSleepTimeMs() {
        return this.baseSleepTimeMs;
    }

    @Override
    public RetryPolicy duplicate() {
        return new ExponentialBackoff(this.baseSleepTimeMs, this.getMaxAttemptCount());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

