/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.retry;

import com.netflix.astyanax.retry.ExponentialBackoff;
import com.netflix.astyanax.retry.RetryPolicy;
import org.apache.commons.lang.builder.ToStringBuilder;

public class BoundedExponentialBackoff
extends ExponentialBackoff {
    private final int maxSleepTimeMs;

    public BoundedExponentialBackoff(int baseSleepTimeMs, int maxSleepTimeMs, int max) {
        super(baseSleepTimeMs, max);
        this.maxSleepTimeMs = maxSleepTimeMs;
    }

    @Override
    public long getSleepTimeMs() {
        return Math.min((long)this.maxSleepTimeMs, super.getSleepTimeMs());
    }

    @Override
    public RetryPolicy duplicate() {
        return new BoundedExponentialBackoff(this.getBaseSleepTimeMs(), this.maxSleepTimeMs, this.getMaxAttemptCount());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

