/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;

public class FixedRetryBackoffStrategy
implements RetryBackoffStrategy {
    private final int interval;
    private final int suspendTime;

    public FixedRetryBackoffStrategy(int interval, int suspendTime) {
        this.interval = interval;
        this.suspendTime = suspendTime;
    }

    @Override
    public RetryBackoffStrategy.Instance createInstance() {
        return new RetryBackoffStrategy.Instance(){
            private boolean isSuspended = false;
            private int attemptCount = 0;

            @Override
            public long getNextDelay() {
                if (this.isSuspended) {
                    this.isSuspended = false;
                    return FixedRetryBackoffStrategy.this.suspendTime;
                }
                return FixedRetryBackoffStrategy.this.interval;
            }

            @Override
            public int getAttemptCount() {
                return this.attemptCount;
            }

            @Override
            public void begin() {
                this.attemptCount = 0;
            }

            @Override
            public void success() {
            }

            @Override
            public void suspend() {
            }
        };
    }
}

