/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.base.Preconditions;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HColumnDescriptor
implements WritableComparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 11;
    public static final String COMPRESSION = "COMPRESSION";
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    public static final String ENCODE_ON_DISK = "ENCODE_ON_DISK";
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String CACHE_DATA_ON_WRITE = "CACHE_DATA_ON_WRITE";
    public static final String CACHE_INDEX_ON_WRITE = "CACHE_INDEX_ON_WRITE";
    public static final String CACHE_BLOOMS_ON_WRITE = "CACHE_BLOOMS_ON_WRITE";
    public static final String EVICT_BLOCKS_ON_CLOSE = "EVICT_BLOCKS_ON_CLOSE";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    public static final byte[] REPLICATION_SCOPE_BYTES = Bytes.toBytes((String)"REPLICATION_SCOPE");
    public static final String MIN_VERSIONS = "MIN_VERSIONS";
    public static final String KEEP_DELETED_CELLS = "KEEP_DELETED_CELLS";
    public static final String COMPRESS_TAGS = "COMPRESS_TAGS";
    public static final String ENCRYPTION = "ENCRYPTION";
    public static final String ENCRYPTION_KEY = "ENCRYPTION_KEY";
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final boolean DEFAULT_ENCODE_ON_DISK = true;
    public static final String DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.NONE.toString();
    public static final int DEFAULT_VERSIONS = HBaseConfiguration.create().getInt("hbase.column.max.version", 1);
    public static final int DEFAULT_MIN_VERSIONS = 0;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_KEEP_DELETED = false;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_INDEX_ON_WRITE = false;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final String DEFAULT_BLOOMFILTER = BloomType.ROW.toString();
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    public static final boolean DEFAULT_EVICT_BLOCKS_ON_CLOSE = false;
    public static final boolean DEFAULT_COMPRESS_TAGS = true;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<ImmutableBytesWritable> RESERVED_KEYWORDS = new HashSet<ImmutableBytesWritable>();
    private static final int UNINITIALIZED = -1;
    private byte[] name;
    private final Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private final Map<String, String> configuration = new HashMap<String, String>();
    private int cachedMaxVersions = -1;

    @Deprecated
    public HColumnDescriptor() {
        this.name = null;
    }

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes((String)familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        this(familyName == null || familyName.length <= 0 ? HConstants.EMPTY_BYTE_ARRAY : familyName, DEFAULT_VERSIONS, DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, DEFAULT_BLOOMFILTER);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : desc.values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : desc.configuration.entrySet()) {
            this.configuration.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.setMaxVersions(desc.getMaxVersions());
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int timeToLive, String bloomFilter) {
        this(familyName, maxVersions, compression, inMemory, blockCacheEnabled, 65536, timeToLive, bloomFilter, 0);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        this(familyName, 0, maxVersions, false, compression, true, DEFAULT_DATA_BLOCK_ENCODING, inMemory, blockCacheEnabled, blocksize, timeToLive, bloomFilter, scope);
    }

    @Deprecated
    public HColumnDescriptor(byte[] familyName, int minVersions, int maxVersions, boolean keepDeletedCells, String compression, boolean encodeOnDisk, String dataBlockEncoding, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        HColumnDescriptor.isLegalFamilyName(familyName);
        this.name = familyName;
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (minVersions > 0) {
            if (timeToLive == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Minimum versions requires TTL.");
            }
            if (minVersions >= maxVersions) {
                throw new IllegalArgumentException("Minimum versions must be < maximum versions.");
            }
        }
        this.setMaxVersions(maxVersions);
        this.setMinVersions(minVersions);
        this.setKeepDeletedCells(keepDeletedCells);
        this.setInMemory(inMemory);
        this.setBlockCacheEnabled(blockCacheEnabled);
        this.setTimeToLive(timeToLive);
        this.setCompressionType(Compression.Algorithm.valueOf((String)compression.toUpperCase()));
        this.setDataBlockEncoding(DataBlockEncoding.valueOf((String)dataBlockEncoding.toUpperCase()));
        this.setBloomFilterType(BloomType.valueOf(bloomFilter.toUpperCase()));
        this.setBlocksize(blocksize);
        this.setScope(scope);
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        Preconditions.checkArgument((b.length != 0 ? 1 : 0) != 0, (Object)"Family name can not be empty");
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString((byte[])b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58 && b[i] != 92 && b[i] != 47) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString((byte[])b));
        }
        byte[] recoveredEdit = Bytes.toBytes((String)"recovered.edits");
        if (Bytes.equals((byte[])recoveredEdit, (byte[])b)) {
            throw new IllegalArgumentException("Family name cannot be: recovered.edits");
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString((byte[])this.name);
    }

    public byte[] getValue(byte[] key) {
        ImmutableBytesWritable ibw = this.values.get(new ImmutableBytesWritable(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes((String)key));
        if (value == null) {
            return null;
        }
        return Bytes.toString((byte[])value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public HColumnDescriptor setValue(byte[] key, byte[] value) {
        this.values.put(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
        return this;
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public HColumnDescriptor setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes((String)key));
        } else {
            this.setValue(Bytes.toBytes((String)key), Bytes.toBytes((String)value));
        }
        return this;
    }

    public Compression.Algorithm getCompression() {
        String n = this.getValue(COMPRESSION);
        if (n == null) {
            return Compression.Algorithm.NONE;
        }
        return Compression.Algorithm.valueOf((String)n.toUpperCase());
    }

    public Compression.Algorithm getCompactionCompression() {
        String n = this.getValue(COMPRESSION_COMPACT);
        if (n == null) {
            return this.getCompression();
        }
        return Compression.Algorithm.valueOf((String)n.toUpperCase());
    }

    public int getMaxVersions() {
        if (this.cachedMaxVersions == -1) {
            String v = this.getValue("VERSIONS");
            this.cachedMaxVersions = Integer.parseInt(v);
        }
        return this.cachedMaxVersions;
    }

    public HColumnDescriptor setMaxVersions(int maxVersions) {
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (maxVersions < this.getMinVersions()) {
            throw new IllegalArgumentException("Set MaxVersion to " + maxVersions + " while minVersion is " + this.getMinVersions() + ". Maximum versions must be >= minimum versions ");
        }
        this.setValue("VERSIONS", Integer.toString(maxVersions));
        this.cachedMaxVersions = maxVersions;
        return this;
    }

    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public HColumnDescriptor setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
        return this;
    }

    public Compression.Algorithm getCompressionType() {
        return this.getCompression();
    }

    public HColumnDescriptor setCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION, type.getName().toUpperCase());
    }

    @Deprecated
    public DataBlockEncoding getDataBlockEncodingOnDisk() {
        return this.getDataBlockEncoding();
    }

    @Deprecated
    public HColumnDescriptor setEncodeOnDisk(boolean encodeOnDisk) {
        return this;
    }

    public DataBlockEncoding getDataBlockEncoding() {
        String type = this.getValue(DATA_BLOCK_ENCODING);
        if (type == null) {
            type = DEFAULT_DATA_BLOCK_ENCODING;
        }
        return DataBlockEncoding.valueOf((String)type);
    }

    public HColumnDescriptor setDataBlockEncoding(DataBlockEncoding type) {
        String name = type != null ? type.toString() : DataBlockEncoding.NONE.toString();
        return this.setValue(DATA_BLOCK_ENCODING, name);
    }

    public HColumnDescriptor setCompressTags(boolean compressTags) {
        return this.setValue(COMPRESS_TAGS, String.valueOf(compressTags));
    }

    public boolean shouldCompressTags() {
        String compressTagsStr = this.getValue(COMPRESS_TAGS);
        boolean compressTags = true;
        if (compressTagsStr != null) {
            compressTags = Boolean.valueOf(compressTagsStr);
        }
        return compressTags;
    }

    public Compression.Algorithm getCompactionCompressionType() {
        return this.getCompactionCompression();
    }

    public HColumnDescriptor setCompactionCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION_COMPACT, type.getName().toUpperCase());
    }

    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setInMemory(boolean inMemory) {
        return this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    public boolean getKeepDeletedCells() {
        String value = this.getValue(KEEP_DELETED_CELLS);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setKeepDeletedCells(boolean keepDeletedCells) {
        return this.setValue(KEEP_DELETED_CELLS, Boolean.toString(keepDeletedCells));
    }

    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.valueOf(value) : Integer.MAX_VALUE;
    }

    public HColumnDescriptor setTimeToLive(int timeToLive) {
        return this.setValue(TTL, Integer.toString(timeToLive));
    }

    public int getMinVersions() {
        String value = this.getValue(MIN_VERSIONS);
        return value != null ? Integer.valueOf(value) : 0;
    }

    public HColumnDescriptor setMinVersions(int minVersions) {
        return this.setValue(MIN_VERSIONS, Integer.toString(minVersions));
    }

    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public HColumnDescriptor setBlockCacheEnabled(boolean blockCacheEnabled) {
        return this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    public BloomType getBloomFilterType() {
        String n = this.getValue(BLOOMFILTER);
        if (n == null) {
            n = DEFAULT_BLOOMFILTER;
        }
        return BloomType.valueOf(n.toUpperCase());
    }

    public HColumnDescriptor setBloomFilterType(BloomType bt) {
        return this.setValue(BLOOMFILTER, bt.toString());
    }

    public int getScope() {
        byte[] value = this.getValue(REPLICATION_SCOPE_BYTES);
        if (value != null) {
            return Integer.valueOf(Bytes.toString((byte[])value));
        }
        return 0;
    }

    public HColumnDescriptor setScope(int scope) {
        return this.setValue(REPLICATION_SCOPE, Integer.toString(scope));
    }

    public boolean shouldCacheDataOnWrite() {
        String value = this.getValue(CACHE_DATA_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheDataOnWrite(boolean value) {
        return this.setValue(CACHE_DATA_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldCacheIndexesOnWrite() {
        String value = this.getValue(CACHE_INDEX_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheIndexesOnWrite(boolean value) {
        return this.setValue(CACHE_INDEX_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldCacheBloomsOnWrite() {
        String value = this.getValue(CACHE_BLOOMS_ON_WRITE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setCacheBloomsOnWrite(boolean value) {
        return this.setValue(CACHE_BLOOMS_ON_WRITE, Boolean.toString(value));
    }

    public boolean shouldEvictBlocksOnClose() {
        String value = this.getValue(EVICT_BLOCKS_ON_CLOSE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public HColumnDescriptor setEvictBlocksOnClose(boolean value) {
        return this.setValue(EVICT_BLOCKS_ON_CLOSE, Boolean.toString(value));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString((byte[])this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(true));
        s.append('}');
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString((byte[])this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(false));
        s.append('}');
        return s.toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        StringBuilder s = new StringBuilder();
        boolean hasConfigKeys = false;
        for (ImmutableBytesWritable k : this.values.keySet()) {
            if (!RESERVED_KEYWORDS.contains(k)) {
                hasConfigKeys = true;
                continue;
            }
            String string = Bytes.toString((byte[])k.get());
            String value = Bytes.toStringBinary((byte[])this.values.get(k).get());
            if (!printDefaults && DEFAULT_VALUES.containsKey(string) && DEFAULT_VALUES.get(string).equalsIgnoreCase(value)) continue;
            s.append(", ");
            s.append(string);
            s.append(" => ");
            s.append('\'').append(value).append('\'');
        }
        if (hasConfigKeys) {
            s.append(", ");
            s.append("METADATA").append(" => ");
            s.append('{');
            boolean printComma = false;
            for (ImmutableBytesWritable immutableBytesWritable : this.values.keySet()) {
                if (RESERVED_KEYWORDS.contains(immutableBytesWritable)) continue;
                String key = Bytes.toString((byte[])immutableBytesWritable.get());
                String value = Bytes.toStringBinary((byte[])this.values.get(immutableBytesWritable).get());
                if (printComma) {
                    s.append(", ");
                }
                printComma = true;
                s.append('\'').append(key).append('\'');
                s.append(" => ");
                s.append('\'').append(value).append('\'');
            }
            s.append('}');
        }
        if (!this.configuration.isEmpty()) {
            s.append(", ");
            s.append("CONFIGURATION").append(" => ");
            s.append('{');
            boolean printCommaForConfiguration = false;
            for (Map.Entry entry : this.configuration.entrySet()) {
                if (printCommaForConfiguration) {
                    s.append(", ");
                }
                printCommaForConfiguration = true;
                s.append('\'').append((String)entry.getKey()).append('\'');
                s.append(" => ");
                s.append('\'').append((String)entry.getValue()).append('\'');
            }
            s.append("}");
        }
        return s;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode((byte[])this.name);
        result ^= Byte.valueOf((byte)11).hashCode();
        result ^= this.values.hashCode();
        return result ^= this.configuration.hashCode();
    }

    @Deprecated
    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version < 6) {
            if (version <= 2) {
                Text t = new Text();
                t.readFields(in);
                this.name = t.getBytes();
            } else {
                this.name = Bytes.readByteArray((DataInput)in);
            }
            this.values.clear();
            this.setMaxVersions(in.readInt());
            int ordinal = in.readInt();
            this.setCompressionType(Compression.Algorithm.values()[ordinal]);
            this.setInMemory(in.readBoolean());
            this.setBloomFilterType(in.readBoolean() ? BloomType.ROW : BloomType.NONE);
            if (this.getBloomFilterType() != BloomType.NONE && version < 5) {
                throw new UnsupportedClassVersionError(this.getClass().getName() + " does not support backward compatibility with versions older " + "than version 5");
            }
            if (version > 1) {
                this.setBlockCacheEnabled(in.readBoolean());
            }
            if (version > 2) {
                this.setTimeToLive(in.readInt());
            }
        } else {
            String value;
            this.name = Bytes.readByteArray((DataInput)in);
            this.values.clear();
            int numValues = in.readInt();
            for (int i = 0; i < numValues; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value2 = new ImmutableBytesWritable();
                key.readFields(in);
                value2.readFields(in);
                if (version < 8 && Bytes.toString((byte[])key.get()).equals(BLOOMFILTER)) {
                    value2.set(Bytes.toBytes((String)(Boolean.getBoolean(Bytes.toString((byte[])value2.get())) ? BloomType.ROW.toString() : BloomType.NONE.toString())));
                }
                this.values.put(key, value2);
            }
            if (version == 6) {
                this.setValue(COMPRESSION, Compression.Algorithm.NONE.getName());
            }
            int n = this.cachedMaxVersions = (value = this.getValue("VERSIONS")) != null ? Integer.valueOf(value) : DEFAULT_VERSIONS;
            if (version > 10) {
                this.configuration.clear();
                int numConfigs = in.readInt();
                for (int i = 0; i < numConfigs; ++i) {
                    ImmutableBytesWritable key = new ImmutableBytesWritable();
                    ImmutableBytesWritable val = new ImmutableBytesWritable();
                    key.readFields(in);
                    val.readFields(in);
                    this.configuration.put(Bytes.toString((byte[])key.get(), (int)key.getOffset(), (int)key.getLength()), Bytes.toString((byte[])val.get(), (int)val.getOffset(), (int)val.getLength()));
                }
            }
        }
    }

    @Deprecated
    public void write(DataOutput out) throws IOException {
        out.writeByte(11);
        Bytes.writeByteArray((DataOutput)out, (byte[])this.name);
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            entry.getKey().write(out);
            entry.getValue().write(out);
        }
        out.writeInt(this.configuration.size());
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            new ImmutableBytesWritable(Bytes.toBytes((String)((String)entry.getKey()))).write(out);
            new ImmutableBytesWritable(Bytes.toBytes((String)((String)entry.getValue()))).write(out);
        }
    }

    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo((byte[])this.name, (byte[])o.getName());
        if (result == 0) {
            result = this.values.hashCode() - o.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        if (result == 0) {
            result = this.configuration.hashCode() - o.configuration.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public static HColumnDescriptor parseFrom(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("No magic");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        HBaseProtos.ColumnFamilySchema cfs = null;
        try {
            cfs = ((HBaseProtos.ColumnFamilySchema.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return HColumnDescriptor.convert(cfs);
    }

    public static HColumnDescriptor convert(HBaseProtos.ColumnFamilySchema cfs) {
        HColumnDescriptor hcd = new HColumnDescriptor();
        hcd.name = cfs.getName().toByteArray();
        for (HBaseProtos.BytesBytesPair a : cfs.getAttributesList()) {
            hcd.setValue(a.getFirst().toByteArray(), a.getSecond().toByteArray());
        }
        for (HBaseProtos.BytesBytesPair a : cfs.getConfigurationList()) {
            hcd.setConfiguration(a.getName(), a.getValue());
        }
        return hcd;
    }

    public HBaseProtos.ColumnFamilySchema convert() {
        HBaseProtos.BytesBytesPair.Builder aBuilder;
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        builder.setName(HBaseZeroCopyByteString.wrap((byte[])this.getName()));
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> entry : this.values.entrySet()) {
            aBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            aBuilder.setFirst(HBaseZeroCopyByteString.wrap((byte[])entry.getKey().get()));
            aBuilder.setSecond(HBaseZeroCopyByteString.wrap((byte[])entry.getValue().get()));
            builder.addAttributes(aBuilder.build());
        }
        for (Map.Entry<Object, Object> entry : this.configuration.entrySet()) {
            aBuilder = HBaseProtos.NameStringPair.newBuilder();
            aBuilder.setName((String)entry.getKey());
            aBuilder.setValue((String)entry.getValue());
            builder.addConfiguration(aBuilder.build());
        }
        return builder.build();
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public void setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configuration.put(key, value);
        }
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public String getEncryptionType() {
        return this.getValue(ENCRYPTION);
    }

    public HColumnDescriptor setEncryptionType(String algorithm) {
        this.setValue(ENCRYPTION, algorithm);
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.getValue(Bytes.toBytes((String)ENCRYPTION_KEY));
    }

    public HColumnDescriptor setEncryptionKey(byte[] keyBytes) {
        this.setValue(Bytes.toBytes((String)ENCRYPTION_KEY), keyBytes);
        return this;
    }

    static {
        DEFAULT_VALUES.put(BLOOMFILTER, DEFAULT_BLOOMFILTER);
        DEFAULT_VALUES.put(REPLICATION_SCOPE, String.valueOf(0));
        DEFAULT_VALUES.put("VERSIONS", String.valueOf(DEFAULT_VERSIONS));
        DEFAULT_VALUES.put(MIN_VERSIONS, String.valueOf(0));
        DEFAULT_VALUES.put(COMPRESSION, DEFAULT_COMPRESSION);
        DEFAULT_VALUES.put(TTL, String.valueOf(Integer.MAX_VALUE));
        DEFAULT_VALUES.put(BLOCKSIZE, String.valueOf(65536));
        DEFAULT_VALUES.put("IN_MEMORY", String.valueOf(false));
        DEFAULT_VALUES.put(BLOCKCACHE, String.valueOf(true));
        DEFAULT_VALUES.put(KEEP_DELETED_CELLS, String.valueOf(false));
        DEFAULT_VALUES.put(DATA_BLOCK_ENCODING, String.valueOf(DEFAULT_DATA_BLOCK_ENCODING));
        DEFAULT_VALUES.put(CACHE_DATA_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_INDEX_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_BLOOMS_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(EVICT_BLOCKS_ON_CLOSE, String.valueOf(false));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes((String)s)));
        }
        RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes((String)ENCRYPTION)));
        RESERVED_KEYWORDS.add(new ImmutableBytesWritable(Bytes.toBytes((String)ENCRYPTION_KEY)));
    }
}

