/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.utils;

import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.CassandraDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemonWrapper {
    private static final Logger log = LoggerFactory.getLogger(CassandraDaemonWrapper.class);
    private static String activeConfig;
    private static boolean started;

    public static synchronized void start(String config) {
        if (started) {
            if (null != config && !config.equals(activeConfig)) {
                log.warn("Can't start in-process Cassandra instance with yaml path {} because an instance was previously started with yaml path {}", (Object)config, (Object)activeConfig);
            }
            return;
        }
        started = true;
        log.debug("Current working directory: {}", (Object)System.getProperty("user.dir"));
        System.setProperty("cassandra.config", config);
        System.setProperty("cassandra-foreground", "yes");
        System.setProperty("log4j.defaultInitOverride", "false");
        log.info("Starting cassandra with {}", (Object)config);
        CassandraDaemon.main((String[])new String[0]);
        activeConfig = config;
        new CassandraKiller(Thread.currentThread()).start();
    }

    public static synchronized boolean isStarted() {
        return started;
    }

    public static void stop() {
    }

    private static void terminatePeriodicCommitLogThread() {
        ThreadGroup root = CassandraDaemonWrapper.getRootThreadGroup();
        if (null == root) {
            return;
        }
        int tc = 4096;
        Thread[] threads = new Thread[tc];
        int enumerated = root.enumerate(threads);
        if (enumerated == tc) {
            return;
        }
        for (int i = 0; i < enumerated; ++i) {
            Thread t = threads[i];
            if (!t.getName().equals("PERIODIC-COMMIT-LOG-SYNCER")) continue;
            CassandraDaemonWrapper.installUncaughtInterruptSwallower(t);
            t.interrupt();
        }
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        if (null == g) {
            return null;
        }
        for (ThreadGroup next = g.getParent(); null != next; next = next.getParent()) {
            g = next;
        }
        return g;
    }

    private static void installUncaughtInterruptSwallower(final Thread t) {
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread actualThread, Throwable a) {
                Throwable cause;
                if (t.equals(actualThread) && a instanceof AssertionError && null != (cause = a.getCause()) && cause instanceof InterruptedException) {
                    return;
                }
                log.error("Uncaught exception", a);
            }
        });
        log.debug("Installed uncaught exception handler on {}", (Object)t);
    }

    private static class CassandraKiller
    extends Thread {
        private final Thread protector;

        public CassandraKiller(Thread protector) {
            this.protector = protector;
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName());
        }

        @Override
        public void run() {
            try {
                log.info("Joining thread {}", (Object)this.protector.getName());
                this.protector.join();
            }
            catch (InterruptedException e) {
                log.info("Cassandra killer aborting due to interrupt", (Throwable)e);
                return;
            }
            log.info("Killing embedded Cassandra threads because {} died", (Object)this.protector);
            CassandraDaemon.stop(null);
            try {
                CommitLog.instance.shutdownBlocking();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            CommitLog.instance.sync();
            CassandraDaemonWrapper.terminatePeriodicCommitLogThread();
            MessagingService.instance().shutdown();
        }
    }
}

