/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.cassandra.thrift.CassandraThriftKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import com.thinkaurelius.titan.diskstorage.cassandra.thrift.thriftpool.CTConnectionFactory;
import com.thinkaurelius.titan.diskstorage.cassandra.thrift.thriftpool.CTConnectionPool;
import com.thinkaurelius.titan.diskstorage.cassandra.utils.CassandraHelper;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.util.system.NetworkUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.dht.AbstractByteOrderedPartitioner;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraThriftStoreManager
extends AbstractCassandraStoreManager {
    private static final Logger log = LoggerFactory.getLogger(CassandraThriftStoreManager.class);
    private final Map<String, CassandraThriftKeyColumnValueStore> openStores;
    private final CTConnectionPool pool;
    private final DistributedStoreManager.Deployment deployment;

    public CassandraThriftStoreManager(Configuration config) throws StorageException {
        super(config);
        int thriftTimeoutMS = (int)((Duration)config.get(GraphDatabaseConfiguration.CONNECTION_TIMEOUT, new String[0])).getLength(TimeUnit.MILLISECONDS);
        int maxTotalConnections = (Integer)config.get(GraphDatabaseConfiguration.CONNECTION_POOL_SIZE, new String[0]);
        CTConnectionFactory.Config factoryConfig = new CTConnectionFactory.Config(this.hostnames, this.port, this.username, this.password).setTimeoutMS(thriftTimeoutMS).setFrameSize(this.thriftFrameSize);
        if (((Boolean)config.get(SSL_ENABLED, new String[0])).booleanValue()) {
            factoryConfig.setSSLTruststoreLocation((String)config.get(SSL_TRUSTSTORE_LOCATION, new String[0]));
            factoryConfig.setSSLTruststorePassword((String)config.get(SSL_TRUSTSTORE_PASSWORD, new String[0]));
        }
        CTConnectionPool p = new CTConnectionPool(factoryConfig.build());
        p.setTestOnBorrow(true);
        p.setTestOnReturn(true);
        p.setTestWhileIdle(false);
        p.setWhenExhaustedAction((byte)1);
        p.setMaxActive(-1);
        p.setMaxTotal(maxTotalConnections);
        p.setMinIdle(0);
        p.setMinEvictableIdleTimeMillis(60000L);
        p.setTimeBetweenEvictionRunsMillis(30000L);
        this.pool = p;
        this.openStores = new HashMap<String, CassandraThriftKeyColumnValueStore>();
        this.deployment = this.getCassandraPartitioner() instanceof ByteOrderedPartitioner ? (this.hostnames.length == 1 ? (NetworkUtil.isLocalConnection((String)this.hostnames[0]) ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE) : DistributedStoreManager.Deployment.REMOTE) : DistributedStoreManager.Deployment.REMOTE;
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public IPartitioner<? extends Token<?>> getCassandraPartitioner() throws StorageException {
        CTConnection conn = null;
        try {
            conn = (CTConnection)this.pool.borrowObject("system");
            IPartitioner iPartitioner = FBUtilities.newPartitioner((String)conn.getClient().describe_partitioner());
            return iPartitioner;
        }
        catch (Exception e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe("system", conn);
        }
    }

    @Override
    public String toString() {
        return "thriftCassandra" + super.toString();
    }

    public void close() throws StorageException {
        this.openStores.clear();
        this.closePool();
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        Preconditions.checkNotNull(mutations);
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp((DistributedStoreManager)this, txh);
        ConsistencyLevel consistency = CassandraTransaction.getTx(txh).getWriteConsistencyLevel().getThrift();
        int size = 0;
        for (Map<StaticBuffer, KCVMutation> mutation : mutations.values()) {
            size += mutation.size();
        }
        HashMap batch = new HashMap(size);
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> keyMutation : mutations.entrySet()) {
            String columnFamily = keyMutation.getKey();
            for (Map.Entry<StaticBuffer, KCVMutation> mutEntry : keyMutation.getValue().entrySet()) {
                Mutation m;
                ByteBuffer keyBB = mutEntry.getKey().asByteBuffer();
                HashMap cfmutation = (HashMap)batch.get(keyBB);
                if (cfmutation == null) {
                    cfmutation = new HashMap(3);
                    batch.put(keyBB, cfmutation);
                }
                KCVMutation mutation = mutEntry.getValue();
                ArrayList<Mutation> thriftMutation = new ArrayList<Mutation>(mutations.size());
                if (mutation.hasDeletions()) {
                    for (StaticBuffer buf : mutation.getDeletions()) {
                        Deletion d = new Deletion();
                        SlicePredicate sp = new SlicePredicate();
                        sp.addToColumn_names((ByteBuffer)buf.as(StaticBuffer.BB_FACTORY));
                        d.setPredicate(sp);
                        d.setTimestamp(commitTime.getDeletionTime(this.times.getUnit()));
                        m = new Mutation();
                        m.setDeletion(d);
                        thriftMutation.add(m);
                    }
                }
                if (mutation.hasAdditions()) {
                    for (Entry ent : mutation.getAdditions()) {
                        ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
                        Column column = new Column((ByteBuffer)ent.getColumnAs(StaticBuffer.BB_FACTORY));
                        column.setValue((ByteBuffer)ent.getValueAs(StaticBuffer.BB_FACTORY));
                        column.setTimestamp(commitTime.getAdditionTime(this.times.getUnit()));
                        cosc.setColumn(column);
                        m = new Mutation();
                        m.setColumn_or_supercolumn(cosc);
                        thriftMutation.add(m);
                    }
                }
                cfmutation.put(columnFamily, thriftMutation);
            }
        }
        CTConnection conn = null;
        try {
            conn = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            Cassandra.Client client = conn.getClient();
            client.batch_mutate(batch, consistency);
        }
        catch (Exception ex) {
            throw CassandraThriftKeyColumnValueStore.convertException(ex);
        }
        finally {
            this.pool.returnObjectUnsafe(this.keySpaceName, conn);
        }
        this.sleepAfterWrite(txh, commitTime);
    }

    public synchronized CassandraThriftKeyColumnValueStore openDatabase(String name) throws StorageException {
        if (this.openStores.containsKey(name)) {
            return this.openStores.get(name);
        }
        this.ensureColumnFamilyExists(this.keySpaceName, name);
        CassandraThriftKeyColumnValueStore store = new CassandraThriftKeyColumnValueStore(this.keySpaceName, name, this, this.pool);
        this.openStores.put(name, store);
        return store;
    }

    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        CTConnection conn = null;
        IPartitioner<? extends Token<?>> partitioner = this.getCassandraPartitioner();
        if (!(partitioner instanceof AbstractByteOrderedPartitioner)) {
            throw new UnsupportedOperationException("getLocalKeyPartition() only supported by byte ordered partitioner.");
        }
        Token.TokenFactory tokenFactory = partitioner.getTokenFactory();
        try {
            conn = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            List ranges = conn.getClient().describe_ring(this.keySpaceName);
            ArrayList<KeyRange> keyRanges = new ArrayList<KeyRange>(ranges.size());
            for (TokenRange range : ranges) {
                if (!NetworkUtil.hasLocalAddress((Collection)range.endpoints)) continue;
                keyRanges.add(CassandraHelper.transformRange(tokenFactory.fromString(range.start_token), tokenFactory.fromString(range.end_token)));
            }
            ArrayList<KeyRange> arrayList = keyRanges;
            return arrayList;
        }
        catch (Exception e) {
            throw CassandraThriftKeyColumnValueStore.convertException(e);
        }
        finally {
            this.pool.returnObjectUnsafe(this.keySpaceName, conn);
        }
    }

    /*
     * Loose catch block
     */
    public void clearStorage() throws StorageException {
        block37: {
            this.openStores.clear();
            String lp = "ClearStorage: ";
            CTConnection conn = null;
            try {
                KsDef ksDef;
                conn = (CTConnection)this.pool.borrowObject("system");
                Cassandra.Client client = conn.getClient();
                try {
                    client.set_keyspace(this.keySpaceName);
                    ksDef = client.describe_keyspace(this.keySpaceName);
                }
                catch (NotFoundException e) {
                    log.debug("ClearStorage: Keyspace {} does not exist, not attempting to truncate.", (Object)this.keySpaceName);
                    if (conn != null && conn.getClient() != null) {
                        try {
                            conn.getClient().set_keyspace("system");
                        }
                        catch (InvalidRequestException e2) {
                            log.warn("Failed to reset keyspace", (Throwable)e2);
                        }
                        catch (TException e3) {
                            log.warn("Failed to reset keyspace", (Throwable)e3);
                        }
                    }
                    this.pool.returnObjectUnsafe("system", conn);
                    return;
                }
                catch (InvalidRequestException e) {
                    block36: {
                        log.debug("ClearStorage: InvalidRequestException when attempting to describe keyspace {}, not attempting to truncate.", (Object)this.keySpaceName);
                        if (conn == null || conn.getClient() == null) break block36;
                        try {
                            conn.getClient().set_keyspace("system");
                        }
                        catch (InvalidRequestException e4) {
                            log.warn("Failed to reset keyspace", (Throwable)e4);
                        }
                        catch (TException e5) {
                            log.warn("Failed to reset keyspace", (Throwable)e5);
                        }
                    }
                    this.pool.returnObjectUnsafe("system", conn);
                    return;
                }
                if (null == ksDef) {
                    log.debug("ClearStorage: Received null KsDef for keyspace {}; not truncating its CFs", (Object)this.keySpaceName);
                    return;
                }
                List cfDefs = ksDef.getCf_defs();
                if (null == cfDefs) {
                    log.debug("ClearStorage: Received empty CfDef list for keyspace {}; not truncating CFs", (Object)this.keySpaceName);
                    return;
                }
                for (CfDef cfDef : ksDef.getCf_defs()) {
                    client.truncate(cfDef.name);
                    log.info("ClearStorage: Truncated CF {} in keyspace {}", (Object)cfDef.name, (Object)this.keySpaceName);
                }
                {
                    break block37;
                    catch (Exception e) {
                        throw new TemporaryStorageException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (conn != null && conn.getClient() != null) {
                    try {
                        conn.getClient().set_keyspace("system");
                    }
                    catch (InvalidRequestException e) {
                        log.warn("Failed to reset keyspace", (Throwable)e);
                    }
                    catch (TException e) {
                        log.warn("Failed to reset keyspace", (Throwable)e);
                    }
                }
                this.pool.returnObjectUnsafe("system", conn);
            }
        }
    }

    private KsDef ensureKeyspaceExists(String keyspaceName) throws TException, StorageException {
        CTConnection connection = null;
        try {
            connection = (CTConnection)this.pool.borrowObject("system");
            Cassandra.Client client = connection.getClient();
            try {
                client.set_keyspace(keyspaceName);
                client.set_keyspace("system");
                log.debug("Found existing keyspace {}", (Object)keyspaceName);
            }
            catch (InvalidRequestException e) {
                log.debug("Creating keyspace {}...", (Object)keyspaceName);
                KsDef ksdef = new KsDef().setName(keyspaceName).setCf_defs(new LinkedList()).setStrategy_class((String)this.storageConfig.get(REPLICATION_STRATEGY, new String[0])).setStrategy_options(this.strategyOptions);
                client.set_keyspace("system");
                try {
                    client.system_add_keyspace(ksdef);
                    this.retrySetKeyspace(keyspaceName, client);
                    log.debug("Created keyspace {}", (Object)keyspaceName);
                }
                catch (InvalidRequestException ire) {
                    log.error("system_add_keyspace failed for keyspace=" + keyspaceName, (Throwable)ire);
                    throw ire;
                }
            }
            KsDef ksDef = client.describe_keyspace(keyspaceName);
            return ksDef;
        }
        catch (Exception e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe("system", connection);
        }
    }

    private void retrySetKeyspace(String ksName, Cassandra.Client client) throws StorageException {
        long end = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() <= end) {
            try {
                client.set_keyspace(ksName);
                return;
            }
            catch (Exception e) {
                log.warn("Exception when changing to keyspace {} after creating it", (Object)ksName, (Object)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new PermanentStorageException("Unexpected interrupt (shutting down?)", (Throwable)ie);
                }
            }
        }
        throw new PermanentStorageException("Could change to keyspace " + ksName + " after creating it");
    }

    private void ensureColumnFamilyExists(String ksName, String cfName) throws StorageException {
        this.ensureColumnFamilyExists(ksName, cfName, "org.apache.cassandra.db.marshal.BytesType");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureColumnFamilyExists(String ksName, String cfName, String comparator) throws StorageException {
        CTConnection conn = null;
        try {
            KsDef keyspaceDef = this.ensureKeyspaceExists(ksName);
            conn = (CTConnection)this.pool.borrowObject(ksName);
            Cassandra.Client client = conn.getClient();
            log.debug("Looking up metadata on keyspace {}...", (Object)ksName);
            boolean foundColumnFamily = false;
            for (CfDef cfDef : keyspaceDef.getCf_defs()) {
                String curCfName = cfDef.getName();
                if (!curCfName.equals(cfName)) continue;
                foundColumnFamily = true;
            }
            if (!foundColumnFamily) {
                this.createColumnFamily(client, ksName, cfName, comparator);
            } else {
                log.debug("Keyspace {} and ColumnFamily {} were found.", (Object)ksName, (Object)cfName);
            }
            this.pool.returnObjectUnsafe(ksName, conn);
            return;
        }
        catch (SchemaDisagreementException e) {
            try {
                throw new TemporaryStorageException((Throwable)e);
                catch (Exception e2) {
                    throw new PermanentStorageException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.pool.returnObjectUnsafe(ksName, conn);
                throw throwable;
            }
        }
    }

    private void createColumnFamily(Cassandra.Client client, String ksName, String cfName, String comparator) throws StorageException {
        CfDef createColumnFamily = new CfDef();
        createColumnFamily.setName(cfName);
        createColumnFamily.setKeyspace(ksName);
        createColumnFamily.setComparator_type(comparator);
        ImmutableMap.Builder compressionOptions = new ImmutableMap.Builder();
        if (this.compressionEnabled) {
            compressionOptions.put((Object)"sstable_compression", (Object)this.compressionClass).put((Object)"chunk_length_kb", (Object)Integer.toString(this.compressionChunkSizeKB));
        }
        createColumnFamily.setCompression_options((Map)compressionOptions.build());
        if (cfName.startsWith("edgestore")) {
            createColumnFamily.setCaching("keys_only");
        } else if (cfName.startsWith("graphindex")) {
            createColumnFamily.setCaching("rows_only");
        }
        log.debug("Adding column family {} to keyspace {}...", (Object)cfName, (Object)ksName);
        try {
            client.system_add_column_family(createColumnFamily);
        }
        catch (SchemaDisagreementException e) {
            throw new TemporaryStorageException("Error in setting up column family", (Throwable)e);
        }
        catch (Exception e) {
            throw new PermanentStorageException((Throwable)e);
        }
        log.debug("Added column family {} to keyspace {}.", (Object)cfName, (Object)ksName);
    }

    @Override
    public Map<String, String> getCompressionOptions(String cf) throws StorageException {
        CTConnection conn = null;
        Map result = null;
        try {
            conn = (CTConnection)this.pool.borrowObject(this.keySpaceName);
            Cassandra.Client client = conn.getClient();
            KsDef ksDef = client.describe_keyspace(this.keySpaceName);
            for (CfDef cfDef : ksDef.getCf_defs()) {
                if (null == cfDef || !cfDef.getName().equals(cf)) continue;
                result = cfDef.getCompression_options();
                break;
            }
            Map map = result;
            return map;
        }
        catch (InvalidRequestException e) {
            log.debug("Keyspace {} does not exist", (Object)this.keySpaceName);
            Map<String, String> map = null;
            return map;
        }
        catch (Exception e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        finally {
            this.pool.returnObjectUnsafe(this.keySpaceName, conn);
        }
    }

    private void closePool() {
        try {
            this.pool.close();
            log.info("Closed Thrift connection pooler.");
        }
        catch (Exception e) {
            log.warn("Failed to close connection pooler.  We might be leaking Cassandra connections.", (Throwable)e);
        }
    }
}

