/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.cassandra.embedded.CassandraEmbeddedKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.cassandra.utils.CassandraDaemonWrapper;
import com.thinkaurelius.titan.diskstorage.cassandra.utils.CassandraHelper;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.ByteBufferUtil;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.scheduler.IRequestScheduler;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraEmbeddedStoreManager
extends AbstractCassandraStoreManager {
    private static final Logger log = LoggerFactory.getLogger(CassandraEmbeddedStoreManager.class);
    public static final String CASSANDRA_YAML_DEFAULT = "./conf/cassandra.yaml";
    private final Map<String, CassandraEmbeddedKeyColumnValueStore> openStores;
    private final IRequestScheduler requestScheduler;

    public CassandraEmbeddedStoreManager(Configuration config) throws StorageException {
        super(config);
        if (config.has(CASSANDRA_THRIFT_FRAME_SIZE, new String[0])) {
            log.warn("Couldn't set custom Thrift Frame Size property, use 'cassandrathrift' instead.");
        }
        String cassandraConfig = CASSANDRA_YAML_DEFAULT;
        if (config.has(GraphDatabaseConfiguration.STORAGE_CONF_FILE, new String[0])) {
            cassandraConfig = (String)config.get(GraphDatabaseConfiguration.STORAGE_CONF_FILE, new String[0]);
        }
        assert (cassandraConfig != null && !cassandraConfig.isEmpty());
        File ccf = new File(cassandraConfig);
        if (ccf.exists() && ccf.isAbsolute()) {
            cassandraConfig = "file://" + cassandraConfig;
            log.debug("Set cassandra config string \"{}\"", (Object)cassandraConfig);
        }
        CassandraDaemonWrapper.start(cassandraConfig);
        this.openStores = new HashMap<String, CassandraEmbeddedKeyColumnValueStore>(8);
        this.requestScheduler = DatabaseDescriptor.getRequestScheduler();
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return DistributedStoreManager.Deployment.EMBEDDED;
    }

    @Override
    public IPartitioner<? extends Token<?>> getCassandraPartitioner() throws StorageException {
        try {
            return StorageService.getPartitioner();
        }
        catch (Exception e) {
            log.warn("Could not read local token range: {}", (Throwable)e);
            throw new PermanentStorageException("Could not read partitioner information on cluster", (Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "embeddedCassandra" + super.toString();
    }

    public void close() {
        this.openStores.clear();
        CassandraDaemonWrapper.stop();
    }

    public synchronized KeyColumnValueStore openDatabase(String name) throws StorageException {
        if (this.openStores.containsKey(name)) {
            return this.openStores.get(name);
        }
        this.ensureKeyspaceExists(this.keySpaceName);
        this.ensureColumnFamilyExists(this.keySpaceName, name);
        CassandraEmbeddedKeyColumnValueStore store = new CassandraEmbeddedKeyColumnValueStore(this.keySpaceName, name, this);
        this.openStores.put(name, store);
        return store;
    }

    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        Collection ranges = StorageService.instance.getLocalPrimaryRanges(this.keySpaceName);
        ArrayList<KeyRange> keyRanges = new ArrayList<KeyRange>(ranges.size());
        for (Range range : ranges) {
            keyRanges.add(CassandraHelper.transformRange((Range<Token>)range));
        }
        return keyRanges;
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws StorageException {
        Preconditions.checkNotNull(mutations);
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp((DistributedStoreManager)this, txh);
        int size = 0;
        for (Map<StaticBuffer, KCVMutation> mutation : mutations.values()) {
            size += mutation.size();
        }
        HashMap<StaticBuffer, RowMutation> rowMutations = new HashMap<StaticBuffer, RowMutation>(size);
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> mutEntry : mutations.entrySet()) {
            String columnFamily = mutEntry.getKey();
            for (Map.Entry<StaticBuffer, KCVMutation> titanMutation : mutEntry.getValue().entrySet()) {
                StaticBuffer key = titanMutation.getKey();
                KCVMutation mut = titanMutation.getValue();
                RowMutation rm = (RowMutation)rowMutations.get(key);
                if (rm == null) {
                    rm = new RowMutation(this.keySpaceName, key.asByteBuffer());
                    rowMutations.put(key, rm);
                }
                if (mut.hasAdditions()) {
                    for (Entry e : mut.getAdditions()) {
                        rm.add(columnFamily, (ByteBuffer)e.getColumnAs(StaticBuffer.BB_FACTORY), (ByteBuffer)e.getValueAs(StaticBuffer.BB_FACTORY), commitTime.getAdditionTime(this.times.getUnit()));
                    }
                }
                if (!mut.hasDeletions()) continue;
                for (StaticBuffer col : mut.getDeletions()) {
                    rm.delete(columnFamily, (ByteBuffer)col.as(StaticBuffer.BB_FACTORY), commitTime.getDeletionTime(this.times.getUnit()));
                }
            }
        }
        this.mutate(new ArrayList<RowMutation>(rowMutations.values()), CassandraTransaction.getTx(txh).getWriteConsistencyLevel().getDB());
        this.sleepAfterWrite(txh, commitTime);
    }

    private void mutate(List<RowMutation> cmds, ConsistencyLevel clvl) throws StorageException {
        try {
            this.schedule(DatabaseDescriptor.getRpcTimeout());
            try {
                StorageProxy.mutate(cmds, (ConsistencyLevel)clvl);
            }
            catch (RequestExecutionException e) {
                throw new TemporaryStorageException((Throwable)e);
            }
            finally {
                this.release();
            }
        }
        catch (TimeoutException ex) {
            log.debug("Cassandra TimeoutException", (Throwable)ex);
            throw new TemporaryStorageException((Throwable)ex);
        }
    }

    private void schedule(long timeoutMS) throws TimeoutException {
        this.requestScheduler.queue(Thread.currentThread(), "default", DatabaseDescriptor.getRpcTimeout());
    }

    private void release() {
        this.requestScheduler.release();
    }

    public void clearStorage() throws StorageException {
        this.openStores.clear();
        try {
            KSMetaData ksMetaData = Schema.instance.getKSMetaData(this.keySpaceName);
            if (ksMetaData == null) {
                return;
            }
            for (String cfName : ksMetaData.cfMetaData().keySet()) {
                StorageService.instance.truncate(this.keySpaceName, cfName);
            }
        }
        catch (Exception e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }

    private void ensureKeyspaceExists(String keyspaceName) throws StorageException {
        KSMetaData ksm;
        if (null != Schema.instance.getKeyspaceInstance(keyspaceName)) {
            return;
        }
        String strategyName = (String)this.storageConfig.get(REPLICATION_STRATEGY, new String[0]);
        try {
            ksm = KSMetaData.newKeyspace((String)keyspaceName, (String)strategyName, (Map)this.strategyOptions, (boolean)true);
        }
        catch (ConfigurationException e) {
            throw new PermanentStorageException("Failed to instantiate keyspace metadata for " + keyspaceName, (Throwable)e);
        }
        try {
            MigrationManager.announceNewKeyspace((KSMetaData)ksm);
            log.info("Created keyspace {}", (Object)keyspaceName);
        }
        catch (ConfigurationException e) {
            throw new PermanentStorageException("Failed to create keyspace " + keyspaceName, (Throwable)e);
        }
    }

    private void ensureColumnFamilyExists(String ksName, String cfName) throws StorageException {
        this.ensureColumnFamilyExists(ksName, cfName, (AbstractType<?>)BytesType.instance);
    }

    private void ensureColumnFamilyExists(String keyspaceName, String columnfamilyName, AbstractType<?> comparator) throws StorageException {
        CompressionParameters cp;
        if (null != Schema.instance.getCFMetaData(keyspaceName, columnfamilyName)) {
            return;
        }
        CFMetaData cfm = new CFMetaData(keyspaceName, columnfamilyName, ColumnFamilyType.Standard, comparator, null);
        if (columnfamilyName.startsWith("edgestore")) {
            cfm.caching(CFMetaData.Caching.KEYS_ONLY);
        } else if (columnfamilyName.startsWith("graphindex")) {
            cfm.caching(CFMetaData.Caching.ROWS_ONLY);
        }
        if (this.compressionEnabled) {
            try {
                cp = new CompressionParameters(this.compressionClass, Integer.valueOf(this.compressionChunkSizeKB * 1024), Collections.emptyMap());
                log.debug("Creating CF {}: setting {}={} and {}={} on {}", new Object[]{columnfamilyName, "sstable_compression", this.compressionClass, "chunk_length_kb", this.compressionChunkSizeKB, cp});
            }
            catch (ConfigurationException ce) {
                throw new PermanentStorageException((Throwable)ce);
            }
        } else {
            cp = new CompressionParameters(null);
            log.debug("Creating CF {}: setting {} to null to disable compression", (Object)columnfamilyName, (Object)"sstable_compression");
        }
        cfm.compressionParameters(cp);
        try {
            cfm.addDefaultIndexNames();
        }
        catch (ConfigurationException e) {
            throw new PermanentStorageException("Failed to create column family metadata for " + keyspaceName + ":" + columnfamilyName, (Throwable)e);
        }
        try {
            MigrationManager.announceNewColumnFamily((CFMetaData)cfm);
            log.info("Created CF {} in KS {}", (Object)columnfamilyName, (Object)keyspaceName);
        }
        catch (ConfigurationException e) {
            throw new PermanentStorageException("Failed to create column family " + keyspaceName + ":" + columnfamilyName, (Throwable)e);
        }
        this.retryDummyRead(keyspaceName, columnfamilyName);
    }

    @Override
    public Map<String, String> getCompressionOptions(String cf) throws StorageException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keySpaceName, cf);
        if (cfm == null) {
            return null;
        }
        return ImmutableMap.copyOf((Map)cfm.compressionParameters().asThriftOptions());
    }

    private void retryDummyRead(String ks, String cf) throws PermanentStorageException {
        long limit = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < limit) {
            try {
                TreeSet<ByteBuffer> ss = new TreeSet<ByteBuffer>();
                ss.add(ByteBufferUtil.zeroByteBuffer((int)1));
                NamesQueryFilter nqf = new NamesQueryFilter(ss);
                SliceByNamesReadCommand cmd = new SliceByNamesReadCommand(ks, ByteBufferUtil.zeroByteBuffer((int)1), cf, 1L, nqf);
                StorageProxy.read((List)ImmutableList.of((Object)cmd), (ConsistencyLevel)ConsistencyLevel.QUORUM);
                log.info("Read on CF {} in KS {} succeeded", (Object)cf, (Object)ks);
                return;
            }
            catch (Throwable t) {
                log.warn("Failed to read CF {} in KS {} following creation", new Object[]{cf, ks, t});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new PermanentStorageException((Throwable)e);
                }
            }
        }
        throw new PermanentStorageException("Timed out while attempting to read CF " + cf + " in KS " + ks + " following creation");
    }
}

