/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.astyanax;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.AuthenticationCredentials;
import com.netflix.astyanax.Cluster;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;
import com.netflix.astyanax.connectionpool.SSLConnectionContext;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolType;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.impl.SimpleAuthenticationCredentials;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class AstyanaxStoreManager
extends AbstractCassandraStoreManager {
    private static final Logger log = LoggerFactory.getLogger(AstyanaxStoreManager.class);
    public static final ConfigOption<String> CLUSTER_NAME = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "cluster-name", "Default name for the Cassandra cluster", ConfigOption.Type.MASKABLE, (Object)"Titan Cluster");
    public static final ConfigOption<Integer> MAX_CONNECTIONS_PER_HOST = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "max-connections-per-host", "Maximum pooled connections per host", ConfigOption.Type.MASKABLE, (Object)32);
    public static final ConfigOption<Integer> MAX_CONNECTIONS = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "max-connections", "Maximum open connections allowed in the pool (counting all hosts)", ConfigOption.Type.MASKABLE, (Object)-1);
    public static final ConfigOption<Integer> MAX_OPERATIONS_PER_CONNECTION = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "max-operations-per-connection", "Maximum number of operations allowed per connection before the connection is closed", ConfigOption.Type.MASKABLE, (Object)100000);
    public static final ConfigOption<Integer> MAX_CLUSTER_CONNECTIONS_PER_HOST = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "max-cluster-connections-per-host", "Maximum pooled \"cluster\" connections per host", ConfigOption.Type.MASKABLE, (Object)3);
    public static final ConfigOption<String> NODE_DISCOVERY_TYPE = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "node-discovery-type", "How Astyanax discovers Cassandra cluster nodes", ConfigOption.Type.MASKABLE, (Object)"RING_DESCRIBE");
    public static final ConfigOption<String> HOST_SUPPLIER = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "host-supplier", "Host supplier to use when discovery type is set to DISCOVERY_SERVICE or TOKEN_AWARE", ConfigOption.Type.MASKABLE, String.class);
    public static final ConfigOption<String> CONNECTION_POOL_TYPE = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "connection-pool-type", "Astyanax's connection pooler implementation", ConfigOption.Type.MASKABLE, (Object)"TOKEN_AWARE");
    public static final ConfigOption<String> RETRY_POLICY = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "retry-policy", "Astyanax's retry policy implementation with configuration parameters", ConfigOption.Type.MASKABLE, (Object)"com.netflix.astyanax.retry.BoundedExponentialBackoff,100,25000,8");
    public static final ConfigOption<String> RETRY_BACKOFF_STRATEGY = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "retry-backoff-strategy", "Astyanax's retry backoff strategy with configuration parameters", ConfigOption.Type.MASKABLE, (Object)"com.netflix.astyanax.connectionpool.impl.FixedRetryBackoffStrategy,1000,5000");
    public static final ConfigOption<Integer> RETRY_DELAY_SLICE = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "retry-delay-slice", "Astyanax's connection pool \"retryDelaySlice\" parameter", ConfigOption.Type.MASKABLE, (Object)1000);
    public static final ConfigOption<Integer> RETRY_MAX_DELAY_SLICE = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "retry-max-delay-slice", "Astyanax's connection pool \"retryMaxDelaySlice\" parameter", ConfigOption.Type.MASKABLE, (Object)10);
    public static final ConfigOption<Integer> RETRY_SUSPEND_WINDOW = new ConfigOption(GraphDatabaseConfiguration.STORAGE_NS, "retry-suspend-window", "Astyanax's connection pool \"retryMaxDelaySlice\" parameter", ConfigOption.Type.MASKABLE, (Object)20000);
    private final String clusterName;
    private final AstyanaxContext<Keyspace> keyspaceContext;
    private final AstyanaxContext<Cluster> clusterContext;
    private final RetryPolicy retryPolicy;
    private final int retryDelaySlice;
    private final int retryMaxDelaySlice;
    private final int retrySuspendWindow;
    private final RetryBackoffStrategy retryBackoffStrategy;
    private final Map<String, AstyanaxKeyColumnValueStore> openStores;

    public AstyanaxStoreManager(Configuration config) throws StorageException {
        super(config);
        if (config.has(CASSANDRA_THRIFT_FRAME_SIZE, new String[0])) {
            log.warn("Couldn't set custom Thrift Frame Size property, use 'cassandrathrift' instead.");
        }
        this.clusterName = (String)config.get(CLUSTER_NAME, new String[0]);
        this.retryDelaySlice = (Integer)config.get(RETRY_DELAY_SLICE, new String[0]);
        this.retryMaxDelaySlice = (Integer)config.get(RETRY_MAX_DELAY_SLICE, new String[0]);
        this.retrySuspendWindow = (Integer)config.get(RETRY_SUSPEND_WINDOW, new String[0]);
        this.retryBackoffStrategy = AstyanaxStoreManager.getRetryBackoffStrategy((String)config.get(RETRY_BACKOFF_STRATEGY, new String[0]));
        this.retryPolicy = AstyanaxStoreManager.getRetryPolicy((String)config.get(RETRY_POLICY, new String[0]));
        int maxConnsPerHost = (Integer)config.get(MAX_CONNECTIONS_PER_HOST, new String[0]);
        int maxClusterConnsPerHost = (Integer)config.get(MAX_CLUSTER_CONNECTIONS_PER_HOST, new String[0]);
        this.clusterContext = AstyanaxStoreManager.createCluster(this.getContextBuilder(config, maxClusterConnsPerHost, "Cluster"));
        this.ensureKeyspaceExists((Cluster)this.clusterContext.getClient());
        this.keyspaceContext = this.getContextBuilder(config, maxConnsPerHost, "Keyspace").buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        this.keyspaceContext.start();
        this.openStores = new HashMap<String, AstyanaxKeyColumnValueStore>(8);
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return DistributedStoreManager.Deployment.REMOTE;
    }

    @Override
    public IPartitioner<? extends Token<?>> getCassandraPartitioner() throws StorageException {
        Cluster cl = (Cluster)this.clusterContext.getClient();
        try {
            return FBUtilities.newPartitioner((String)cl.describePartitioner());
        }
        catch (ConnectionException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "astyanax" + super.toString();
    }

    public void close() {
        this.openStores.clear();
        this.keyspaceContext.shutdown();
        this.clusterContext.shutdown();
    }

    public synchronized AstyanaxKeyColumnValueStore openDatabase(String name) throws StorageException {
        if (this.openStores.containsKey(name)) {
            return this.openStores.get(name);
        }
        this.ensureColumnFamilyExists(name);
        AstyanaxKeyColumnValueStore store = new AstyanaxKeyColumnValueStore(name, (Keyspace)this.keyspaceContext.getClient(), this, this.retryPolicy);
        this.openStores.put(name, store);
        return store;
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> batch, StoreTransaction txh) throws StorageException {
        MutationBatch m = ((Keyspace)this.keyspaceContext.getClient()).prepareMutationBatch().setConsistencyLevel(CassandraTransaction.getTx(txh).getWriteConsistencyLevel().getAstyanax()).withRetryPolicy(this.retryPolicy.duplicate());
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp((DistributedStoreManager)this, txh);
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> batchentry : batch.entrySet()) {
            String storeName = batchentry.getKey();
            Preconditions.checkArgument((boolean)this.openStores.containsKey(storeName), (Object)("Store cannot be found: " + storeName));
            ColumnFamily<ByteBuffer, ByteBuffer> columnFamily = this.openStores.get(storeName).getColumnFamily();
            Map<StaticBuffer, KCVMutation> mutations = batchentry.getValue();
            for (Map.Entry<StaticBuffer, KCVMutation> ent : mutations.entrySet()) {
                KCVMutation titanMutation = ent.getValue();
                ByteBuffer key = ent.getKey().asByteBuffer();
                if (titanMutation.hasDeletions()) {
                    ColumnListMutation dels = m.withRow(columnFamily, (Object)key);
                    dels.setTimestamp(commitTime.getDeletionTime(this.times.getUnit()));
                    for (StaticBuffer b : titanMutation.getDeletions()) {
                        dels.deleteColumn(b.as(StaticBuffer.BB_FACTORY));
                    }
                }
                if (!titanMutation.hasAdditions()) continue;
                ColumnListMutation upds = m.withRow(columnFamily, (Object)key);
                upds.setTimestamp(commitTime.getAdditionTime(this.times.getUnit()));
                for (Entry e : titanMutation.getAdditions()) {
                    upds.putColumn(e.getColumnAs(StaticBuffer.BB_FACTORY), (ByteBuffer)e.getValueAs(StaticBuffer.BB_FACTORY));
                }
            }
        }
        try {
            m.execute();
        }
        catch (ConnectionException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        this.sleepAfterWrite(txh, commitTime);
    }

    public List<KeyRange> getLocalKeyPartition() throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void clearStorage() throws StorageException {
        try {
            Cluster cluster = (Cluster)this.clusterContext.getClient();
            Keyspace ks = cluster.getKeyspace(this.keySpaceName);
            if (ks == null) {
                return;
            }
            for (ColumnFamilyDefinition cf : cluster.describeKeyspace(this.keySpaceName).getColumnFamilyList()) {
                ks.truncateColumnFamily(new ColumnFamily(cf.getName(), null, null));
            }
        }
        catch (ConnectionException e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }

    private void ensureColumnFamilyExists(String name) throws StorageException {
        this.ensureColumnFamilyExists(name, "org.apache.cassandra.db.marshal.BytesType");
    }

    private void ensureColumnFamilyExists(String name, String comparator) throws StorageException {
        Cluster cl = (Cluster)this.clusterContext.getClient();
        try {
            KeyspaceDefinition ksDef = cl.describeKeyspace(this.keySpaceName);
            boolean found = false;
            if (null != ksDef) {
                for (ColumnFamilyDefinition cfDef : ksDef.getColumnFamilyList()) {
                    found |= cfDef.getName().equals(name);
                }
            }
            if (!found) {
                ColumnFamilyDefinition cfDef = cl.makeColumnFamilyDefinition().setName(name).setKeyspace(this.keySpaceName).setComparatorType(comparator);
                ImmutableMap.Builder compressionOptions = new ImmutableMap.Builder();
                if (this.compressionEnabled) {
                    compressionOptions.put((Object)"sstable_compression", (Object)this.compressionClass).put((Object)"chunk_length_kb", (Object)Integer.toString(this.compressionChunkSizeKB));
                }
                cl.addColumnFamily(cfDef.setCompressionOptions((Map)compressionOptions.build()));
            }
        }
        catch (ConnectionException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
    }

    private static AstyanaxContext<Cluster> createCluster(AstyanaxContext.Builder cb) {
        AstyanaxContext clusterCtx = cb.buildCluster((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        clusterCtx.start();
        return clusterCtx;
    }

    private AstyanaxContext.Builder getContextBuilder(Configuration config, int maxConnsPerHost, String usedFor) {
        ConnectionPoolType poolType = ConnectionPoolType.valueOf((String)((String)config.get(CONNECTION_POOL_TYPE, new String[0])));
        NodeDiscoveryType discType = NodeDiscoveryType.valueOf((String)((String)config.get(NODE_DISCOVERY_TYPE, new String[0])));
        int maxConnections = (Integer)config.get(MAX_CONNECTIONS, new String[0]);
        int maxOperationsPerConnection = (Integer)config.get(MAX_OPERATIONS_PER_CONNECTION, new String[0]);
        int connectionTimeout = (int)this.connectionTimeoutMS.getLength(TimeUnit.MILLISECONDS);
        ConnectionPoolConfigurationImpl cpool = new ConnectionPoolConfigurationImpl(usedFor + "TitanConnectionPool").setPort(this.port).setMaxOperationsPerConnection(maxOperationsPerConnection).setMaxConnsPerHost(maxConnsPerHost).setRetryDelaySlice(this.retryDelaySlice).setRetryMaxDelaySlice(this.retryMaxDelaySlice).setRetrySuspendWindow(this.retrySuspendWindow).setSocketTimeout(connectionTimeout).setConnectTimeout(connectionTimeout).setSeeds(StringUtils.join((Object[])this.hostnames, (String)","));
        if (null != this.retryBackoffStrategy) {
            cpool.setRetryBackoffStrategy(this.retryBackoffStrategy);
            log.debug("Custom RetryBackoffStrategy {}", (Object)cpool.getRetryBackoffStrategy());
        } else {
            log.debug("Default RetryBackoffStrategy {}", (Object)cpool.getRetryBackoffStrategy());
        }
        AstyanaxConfigurationImpl aconf = new AstyanaxConfigurationImpl().setConnectionPoolType(poolType).setDiscoveryType(discType).setTargetCassandraVersion("1.2");
        if (0 < maxConnections) {
            cpool.setMaxConns(maxConnections);
        }
        if (this.hasAuthentication()) {
            cpool.setAuthenticationCredentials((AuthenticationCredentials)new SimpleAuthenticationCredentials(this.username, this.password));
        }
        if (((Boolean)config.get(SSL_ENABLED, new String[0])).booleanValue()) {
            cpool.setSSLConnectionContext(new SSLConnectionContext((String)config.get(SSL_TRUSTSTORE_LOCATION, new String[0]), (String)config.get(SSL_TRUSTSTORE_PASSWORD, new String[0])));
        }
        AstyanaxContext.Builder ctxBuilder = new AstyanaxContext.Builder();
        ctxBuilder.forCluster(this.clusterName).forKeyspace(this.keySpaceName).withAstyanaxConfiguration((AstyanaxConfiguration)aconf).withConnectionPoolConfiguration((ConnectionPoolConfiguration)cpool).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor());
        if (config.has(HOST_SUPPLIER, new String[0])) {
            String hostSupplier = (String)config.get(HOST_SUPPLIER, new String[0]);
            Supplier supplier = null;
            if (hostSupplier != null) {
                try {
                    supplier = (Supplier)Class.forName(hostSupplier).newInstance();
                    ctxBuilder.withHostSupplier(supplier);
                }
                catch (Exception e) {
                    log.warn("Problem with host supplier class " + hostSupplier + ", going to use default.", (Throwable)e);
                }
            }
        }
        return ctxBuilder;
    }

    private void ensureKeyspaceExists(Cluster cl) throws StorageException {
        KeyspaceDefinition ksDef;
        try {
            ksDef = cl.describeKeyspace(this.keySpaceName);
            if (null != ksDef && ksDef.getName().equals(this.keySpaceName)) {
                log.debug("Found keyspace {}", (Object)this.keySpaceName);
                return;
            }
        }
        catch (ConnectionException e) {
            log.debug("Failed to describe keyspace {}", (Object)this.keySpaceName);
        }
        log.debug("Creating keyspace {}...", (Object)this.keySpaceName);
        try {
            ksDef = cl.makeKeyspaceDefinition().setName(this.keySpaceName).setStrategyClass((String)this.storageConfig.get(REPLICATION_STRATEGY, new String[0])).setStrategyOptions(this.strategyOptions);
            cl.addKeyspace(ksDef);
            log.debug("Created keyspace {}", (Object)this.keySpaceName);
        }
        catch (ConnectionException e) {
            log.debug("Failed to create keyspace {}, keySpaceName");
            throw new TemporaryStorageException((Throwable)e);
        }
    }

    private static RetryBackoffStrategy getRetryBackoffStrategy(String desc) throws PermanentStorageException {
        if (null == desc) {
            return null;
        }
        String[] tokens = desc.split(",");
        String policyClassName = tokens[0];
        int argCount = tokens.length - 1;
        Integer[] args = new Integer[argCount];
        for (int i = 1; i < tokens.length; ++i) {
            args[i - 1] = Integer.valueOf(tokens[i]);
        }
        try {
            RetryBackoffStrategy rbs = (RetryBackoffStrategy)AstyanaxStoreManager.instantiate(policyClassName, args, desc);
            log.debug("Instantiated RetryBackoffStrategy object {} from config string \"{}\"", (Object)rbs, (Object)desc);
            return rbs;
        }
        catch (Exception e) {
            throw new PermanentStorageException("Failed to instantiate Astyanax RetryBackoffStrategy implementation", (Throwable)e);
        }
    }

    private static RetryPolicy getRetryPolicy(String serializedRetryPolicy) throws StorageException {
        String[] tokens = serializedRetryPolicy.split(",");
        String policyClassName = tokens[0];
        int argCount = tokens.length - 1;
        Integer[] args = new Integer[argCount];
        for (int i = 1; i < tokens.length; ++i) {
            args[i - 1] = Integer.valueOf(tokens[i]);
        }
        try {
            RetryPolicy rp = (RetryPolicy)AstyanaxStoreManager.instantiate(policyClassName, args, serializedRetryPolicy);
            log.debug("Instantiated RetryPolicy object {} from config string \"{}\"", (Object)rp, (Object)serializedRetryPolicy);
            return rp;
        }
        catch (Exception e) {
            throw new PermanentStorageException("Failed to instantiate Astyanax Retry Policy class", (Throwable)e);
        }
    }

    private static <V> V instantiate(String policyClassName, Integer[] args, String raw) throws Exception {
        for (Constructor<?> con : Class.forName(policyClassName).getConstructors()) {
            Class<?>[] parameterTypes = con.getParameterTypes();
            if (args.length != parameterTypes.length) continue;
            boolean intsOrLongs = true;
            for (Class<?> pc : parameterTypes) {
                if (pc.equals(Integer.TYPE) || pc.equals(Long.TYPE)) continue;
                intsOrLongs = false;
                break;
            }
            if (!intsOrLongs) continue;
            if (log.isDebugEnabled()) {
                log.debug("About to instantiate class {} with {} arguments", (Object)con.toString(), (Object)args.length);
            }
            return (V)con.newInstance(args);
        }
        throw new Exception("Failed to identify a class matching the Astyanax Retry Policy config string \"" + raw + "\"");
    }

    @Override
    public Map<String, String> getCompressionOptions(String cf) throws StorageException {
        try {
            Keyspace k = (Keyspace)this.keyspaceContext.getClient();
            KeyspaceDefinition kdef = k.describeKeyspace();
            if (null == kdef) {
                throw new PermanentStorageException("Keyspace " + k.getKeyspaceName() + " is undefined");
            }
            ColumnFamilyDefinition cfdef = kdef.getColumnFamily(cf);
            if (null == cfdef) {
                throw new PermanentStorageException("Column family " + cf + " is undefined");
            }
            return cfdef.getCompressionOptions();
        }
        catch (ConnectionException e) {
            throw new PermanentStorageException((Throwable)e);
        }
    }
}

