/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.astyanax;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.RowSliceQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CassandraTransaction;
import com.thinkaurelius.titan.diskstorage.cassandra.astyanax.AstyanaxStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.utils.CassandraHelper;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AstyanaxKeyColumnValueStore
implements KeyColumnValueStore {
    private final Keyspace keyspace;
    private final String columnFamilyName;
    private final ColumnFamily<ByteBuffer, ByteBuffer> columnFamily;
    private final RetryPolicy retryPolicy;
    private final AstyanaxStoreManager storeManager;
    private final AstyanaxGetter entryGetter;

    AstyanaxKeyColumnValueStore(String columnFamilyName, Keyspace keyspace, AstyanaxStoreManager storeManager, RetryPolicy retryPolicy) {
        this.keyspace = keyspace;
        this.columnFamilyName = columnFamilyName;
        this.retryPolicy = retryPolicy;
        this.storeManager = storeManager;
        this.entryGetter = new AstyanaxGetter(storeManager.getMetaDataSchema(columnFamilyName));
        this.columnFamily = new ColumnFamily(this.columnFamilyName, (Serializer)ByteBufferSerializer.get(), (Serializer)ByteBufferSerializer.get());
    }

    ColumnFamily<ByteBuffer, ByteBuffer> getColumnFamily() {
        return this.columnFamily;
    }

    public void close() throws StorageException {
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws StorageException {
        Map<StaticBuffer, EntryList> result = this.getNamesSlice(query.getKey(), (SliceQuery)query, txh);
        return (EntryList)Iterables.getOnlyElement(result.values(), (Object)EntryList.EMPTY_LIST);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.getNamesSlice(keys, query, txh);
    }

    public Map<StaticBuffer, EntryList> getNamesSlice(StaticBuffer key, SliceQuery query, StoreTransaction txh) throws StorageException {
        return this.getNamesSlice((List<StaticBuffer>)ImmutableList.of((Object)key), query, txh);
    }

    public Map<StaticBuffer, EntryList> getNamesSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws StorageException {
        OperationResult r;
        RowSliceQuery rq = this.keyspace.prepareQuery(this.columnFamily).setConsistencyLevel(CassandraTransaction.getTx(txh).getReadConsistencyLevel().getAstyanax()).withRetryPolicy(this.retryPolicy.duplicate()).getKeySlice(CassandraHelper.convert(keys));
        rq.withColumnRange(query.getSliceStart().asByteBuffer(), query.getSliceEnd().asByteBuffer(), false, query.getLimit() + (query.hasLimit() ? 1 : 0));
        try {
            r = rq.execute();
        }
        catch (ConnectionException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        Rows rows = (Rows)r.getResult();
        HashMap<StaticBuffer, EntryList> result = new HashMap<StaticBuffer, EntryList>(rows.size());
        for (Row row : rows) {
            assert (!result.containsKey(row.getKey()));
            result.put((StaticBuffer)StaticArrayBuffer.of((ByteBuffer)((ByteBuffer)row.getKey())), CassandraHelper.makeEntryList(row.getColumns(), this.entryGetter, query.getSliceEnd(), query.getLimit()));
        }
        return result;
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws StorageException {
        this.mutateMany((Map<StaticBuffer, KCVMutation>)ImmutableMap.of((Object)key, (Object)new KCVMutation(additions, deletions)), txh);
    }

    public void mutateMany(Map<StaticBuffer, KCVMutation> mutations, StoreTransaction txh) throws StorageException {
        this.storeManager.mutateMany((Map<String, Map<StaticBuffer, KCVMutation>>)ImmutableMap.of((Object)this.columnFamilyName, mutations), txh);
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(@Nullable SliceQuery sliceQuery, StoreTransaction txh) throws StorageException {
        Rows result;
        if (this.storeManager.getPartitioner() != AbstractCassandraStoreManager.Partitioner.RANDOM) {
            throw new PermanentStorageException("This operation is only allowed when random partitioner (md5 or murmur3) is used.");
        }
        AllRowsQuery allRowsQuery = this.keyspace.prepareQuery(this.columnFamily).getAllRows();
        if (sliceQuery != null) {
            allRowsQuery.withColumnRange(sliceQuery.getSliceStart().asByteBuffer(), sliceQuery.getSliceEnd().asByteBuffer(), false, sliceQuery.getLimit());
        }
        try {
            OperationResult op = allRowsQuery.setRowLimit(this.storeManager.getPageSize()).setConcurrencyLevel(1).setExceptionCallback(new ExceptionCallback(){
                private int retries = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean onException(ConnectionException e) {
                    try {
                        boolean bl = this.retries > 2;
                        return bl;
                    }
                    finally {
                        ++this.retries;
                    }
                }
            }).execute();
            result = (Rows)op.getResult();
        }
        catch (ConnectionException e) {
            throw new PermanentStorageException((Throwable)e);
        }
        return new RowIterator(result.iterator(), sliceQuery);
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws StorageException {
        Rows r;
        AbstractCassandraStoreManager.Partitioner partitioner = this.storeManager.getPartitioner();
        if (partitioner != AbstractCassandraStoreManager.Partitioner.BYTEORDER) {
            throw new PermanentStorageException("getKeys(KeyRangeQuery could only be used with byte-ordering partitioner.");
        }
        ByteBuffer start = query.getKeyStart().asByteBuffer();
        ByteBuffer end = query.getKeyEnd().asByteBuffer();
        RowSliceQuery rowSlice = this.keyspace.prepareQuery(this.columnFamily).setConsistencyLevel(CassandraTransaction.getTx(txh).getReadConsistencyLevel().getAstyanax()).withRetryPolicy(this.retryPolicy.duplicate()).getKeyRange((Object)start, (Object)end, null, null, Integer.MAX_VALUE);
        rowSlice.withColumnRange(query.getSliceStart().asByteBuffer(), query.getSliceEnd().asByteBuffer(), false, query.getLimit());
        try {
            r = (Rows)rowSlice.execute().getResult();
        }
        catch (ConnectionException e) {
            throw new TemporaryStorageException((Throwable)e);
        }
        UnmodifiableIterator i = Iterators.filter((Iterator)r.iterator(), (Predicate)new KeySkipPredicate(query.getKeyEnd().asByteBuffer()));
        return new RowIterator((Iterator<Row<ByteBuffer, ByteBuffer>>)i, (SliceQuery)query);
    }

    public String getName() {
        return this.columnFamilyName;
    }

    private class RowIterator
    implements KeyIterator {
        private final Iterator<Row<ByteBuffer, ByteBuffer>> rows;
        private Row<ByteBuffer, ByteBuffer> currentRow;
        private final SliceQuery sliceQuery;
        private boolean isClosed;

        public RowIterator(Iterator<Row<ByteBuffer, ByteBuffer>> rowIter, SliceQuery sliceQuery) {
            this.rows = Iterators.filter(rowIter, (Predicate)new KeyIterationPredicate());
            this.sliceQuery = sliceQuery;
        }

        public RecordIterator<Entry> getEntries() {
            this.ensureOpen();
            if (this.sliceQuery == null) {
                throw new IllegalStateException("getEntries() requires SliceQuery to be set.");
            }
            return new RecordIterator<Entry>(){
                private final Iterator<Entry> columns;
                {
                    this.columns = CassandraHelper.makeEntryIterator(RowIterator.this.currentRow.getColumns(), AstyanaxKeyColumnValueStore.this.entryGetter, RowIterator.this.sliceQuery.getSliceEnd(), RowIterator.this.sliceQuery.getLimit());
                }

                public boolean hasNext() {
                    RowIterator.this.ensureOpen();
                    return this.columns.hasNext();
                }

                public Entry next() {
                    RowIterator.this.ensureOpen();
                    return this.columns.next();
                }

                public void close() {
                    RowIterator.this.isClosed = true;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean hasNext() {
            this.ensureOpen();
            return this.rows.hasNext();
        }

        public StaticBuffer next() {
            this.ensureOpen();
            this.currentRow = this.rows.next();
            return StaticArrayBuffer.of((ByteBuffer)((ByteBuffer)this.currentRow.getKey()));
        }

        public void close() {
            this.isClosed = true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void ensureOpen() {
            if (this.isClosed) {
                throw new IllegalStateException("Iterator has been closed.");
            }
        }
    }

    private static class KeySkipPredicate
    implements Predicate<Row<ByteBuffer, ByteBuffer>> {
        private final ByteBuffer skip;

        public KeySkipPredicate(ByteBuffer skip) {
            this.skip = skip;
        }

        public boolean apply(@Nullable Row<ByteBuffer, ByteBuffer> row) {
            return row != null && !((ByteBuffer)row.getKey()).equals(this.skip);
        }
    }

    private static class KeyIterationPredicate
    implements Predicate<Row<ByteBuffer, ByteBuffer>> {
        private KeyIterationPredicate() {
        }

        public boolean apply(@Nullable Row<ByteBuffer, ByteBuffer> row) {
            return row != null && row.getColumns().size() > 0;
        }
    }

    private static class AstyanaxGetter
    implements StaticArrayEntry.GetColVal<Column<ByteBuffer>, ByteBuffer> {
        private final EntryMetaData[] schema;

        private AstyanaxGetter(EntryMetaData[] schema) {
            this.schema = schema;
        }

        public ByteBuffer getColumn(Column<ByteBuffer> element) {
            return (ByteBuffer)element.getName();
        }

        public ByteBuffer getValue(Column<ByteBuffer> element) {
            return element.getByteBufferValue();
        }

        public EntryMetaData[] getMetaSchema(Column<ByteBuffer> element) {
            return this.schema;
        }

        public Object getMetaData(Column<ByteBuffer> element, EntryMetaData meta) {
            switch (meta) {
                case TIMESTAMP: {
                    return element.getTimestamp();
                }
                case TTL: {
                    return (long)element.getTtl();
                }
            }
            throw new UnsupportedOperationException("Unsupported meta data: " + meta);
        }
    }
}

