/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.cassandra.CLevel;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTransaction
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(CassandraTransaction.class);

    public CassandraTransaction(BaseTransactionConfig c) {
        super(c);
    }

    public CLevel getReadConsistencyLevel() {
        CLevel lev = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_READ_CONSISTENCY));
        log.debug("Read consistency level for tx {} is {}", (Object)this, (Object)lev);
        return lev;
    }

    public CLevel getWriteConsistencyLevel() {
        CLevel lev = CLevel.parse((String)this.getConfiguration().getCustomOption(AbstractCassandraStoreManager.CASSANDRA_WRITE_CONSISTENCY));
        log.debug("Write consistency level for tx {} is {}", (Object)this, (Object)lev);
        return lev;
    }

    public static CassandraTransaction getTx(StoreTransaction txh) {
        Preconditions.checkArgument((txh != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(txh instanceof CassandraTransaction), (String)"Unexpected transaction type %s", (Object[])new Object[]{txh.getClass().getName()});
        return (CassandraTransaction)txh;
    }
}

