/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.model.Value;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

public class Var
extends QueryModelNodeBase
implements ValueExpr {
    private String name;
    private Value value;
    private boolean anonymous = false;
    private boolean constant = false;

    public Var() {
    }

    public Var(String name) {
        this.setName(name);
    }

    public Var(String name, Value value) {
        this(name);
        this.setValue(value);
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.getSignature());
        sb.append(" (name=").append(this.name);
        if (this.value != null) {
            sb.append(", value=").append(this.value.toString());
        }
        if (this.anonymous) {
            sb.append(", anonymous");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Var) {
            Var o = (Var)other;
            return this.name.equals(o.getName()) && this.nullEquals(this.value, o.getValue()) && this.anonymous == o.isAnonymous();
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        if (this.value != null) {
            result ^= this.value.hashCode();
        }
        if (this.anonymous) {
            result ^= 0xFFFFFFFF;
        }
        return result;
    }

    @Override
    public Var clone() {
        return (Var)super.clone();
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }
}

