/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.ProjectionElemList;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;

public class MultiProjection
extends UnaryTupleOperator {
    private List<ProjectionElemList> projections = new ArrayList<ProjectionElemList>();

    public MultiProjection() {
    }

    public MultiProjection(TupleExpr arg) {
        super(arg);
    }

    public MultiProjection(TupleExpr arg, Iterable<ProjectionElemList> projections) {
        this(arg);
        this.addProjections(projections);
    }

    public List<ProjectionElemList> getProjections() {
        return Collections.unmodifiableList(this.projections);
    }

    public void setProjections(Iterable<ProjectionElemList> projections) {
        this.projections.clear();
        this.addProjections(projections);
    }

    public void addProjections(Iterable<ProjectionElemList> projections) {
        for (ProjectionElemList projection : projections) {
            this.addProjection(projection);
        }
    }

    public void addProjection(ProjectionElemList projection) {
        assert (projection != null) : "projection must not be null";
        this.projections.add(projection);
        projection.setParentNode(this);
    }

    @Override
    public Set<String> getBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>();
        for (ProjectionElemList projElemList : this.projections) {
            bindingNames.addAll(projElemList.getTargetNames());
        }
        return bindingNames;
    }

    @Override
    public Set<String> getAssuredBindingNames() {
        HashSet<String> bindingNames = new HashSet<String>();
        if (this.projections.size() >= 1) {
            Set<String> assuredSourceNames = this.getArg().getAssuredBindingNames();
            bindingNames.addAll(this.projections.get(0).getTargetNamesFor(assuredSourceNames));
            for (int i = 1; i < this.projections.size(); ++i) {
                bindingNames.retainAll(this.projections.get(i).getTargetNamesFor(assuredSourceNames));
            }
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ProjectionElemList projElemList : this.projections) {
            projElemList.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.projections, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MultiProjection && super.equals(other)) {
            MultiProjection o = (MultiProjection)other;
            return this.projections.equals(o.getProjections());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.projections.hashCode();
    }

    @Override
    public MultiProjection clone() {
        MultiProjection clone = (MultiProjection)super.clone();
        clone.projections = new ArrayList<ProjectionElemList>(this.getProjections().size());
        for (ProjectionElemList pe : this.getProjections()) {
            clone.addProjection(pe.clone());
        }
        return clone;
    }
}

