/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DeltaInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BINDelta
implements Loggable {
    private final DatabaseId dbId;
    private long lastFullLsn;
    private long prevDeltaLsn;
    private final ArrayList<DeltaInfo> deltas;

    public BINDelta(BIN bin) {
        this.lastFullLsn = bin.getLastFullVersion();
        this.prevDeltaLsn = bin.getLastDeltaVersion();
        this.dbId = bin.getDatabaseId();
        this.deltas = new ArrayList();
        for (int i = 0; i < bin.getNEntries(); ++i) {
            if (!bin.isDirty(i)) continue;
            this.deltas.add(new DeltaInfo(bin.getKey(i), bin.getLsn(i), bin.getState(i)));
        }
        this.deltas.trimToSize();
    }

    public BINDelta() {
        this.dbId = new DatabaseId();
        this.lastFullLsn = -1L;
        this.prevDeltaLsn = -1L;
        this.deltas = new ArrayList();
    }

    public BINDelta(SizeofMarker marker) {
        this.dbId = new DatabaseId();
        this.lastFullLsn = -1L;
        this.prevDeltaLsn = -1L;
        this.deltas = null;
    }

    int getNumDeltas() {
        return this.deltas.size();
    }

    static int getNumDeltas(BIN bin) {
        int n = 0;
        for (int i = 0; i < bin.getNEntries(); ++i) {
            if (!bin.isDirty(i)) continue;
            ++n;
        }
        return n;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getLastFullLsn() {
        return this.lastFullLsn;
    }

    public long getPrevDeltaLsn() {
        return this.prevDeltaLsn;
    }

    public byte[] getSearchKey() {
        assert (this.deltas.size() > 0);
        return this.deltas.get(0).getKey();
    }

    public BIN reconstituteBIN(DatabaseImpl dbImpl) {
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        BIN fullBIN = (BIN)envImpl.getLogManager().getEntryHandleFileNotFound(this.lastFullLsn);
        this.reconstituteBIN(dbImpl, fullBIN);
        return fullBIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteBIN(DatabaseImpl dbImpl, BIN fullBIN) {
        fullBIN.latch();
        try {
            fullBIN.setDatabase(dbImpl);
            fullBIN.setLastFullLsn(this.lastFullLsn);
            for (int i = 0; i < this.deltas.size(); ++i) {
                DeltaInfo info = this.deltas.get(i);
                int foundIndex = fullBIN.findEntry(info.getKey(), true, false);
                if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
                    foundIndex &= 0xFFFEFFFF;
                    if (info.isKnownDeleted()) {
                        fullBIN.setKnownDeleted(foundIndex);
                        continue;
                    }
                    fullBIN.updateEntry(foundIndex, info.getLsn(), info.getState());
                    continue;
                }
                ChildReference entry = new ChildReference(null, info.getKey(), info.getLsn(), info.getState());
                boolean insertOk = fullBIN.insertEntry(entry);
                assert (insertOk);
            }
            fullBIN.setGeneration(0L);
            fullBIN.setDirty(false);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fullBIN.releaseLatch();
            throw throwable;
        }
        fullBIN.releaseLatch();
    }

    public int getLogSize() {
        int numDeltas = this.deltas.size();
        int size = this.dbId.getLogSize() + LogUtils.getPackedLongLogSize(this.lastFullLsn) + LogUtils.getPackedLongLogSize(this.prevDeltaLsn) + LogUtils.getPackedIntLogSize(numDeltas);
        for (int i = 0; i < numDeltas; ++i) {
            DeltaInfo info = this.deltas.get(i);
            size += info.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.dbId.writeToLog(logBuffer);
        LogUtils.writePackedLong(logBuffer, this.lastFullLsn);
        LogUtils.writePackedLong(logBuffer, this.prevDeltaLsn);
        LogUtils.writePackedInt(logBuffer, this.deltas.size());
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = this.deltas.get(i);
            info.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.dbId.readFromLog(itemBuffer, entryVersion);
        this.lastFullLsn = LogUtils.readLong(itemBuffer, entryVersion < 6);
        if (entryVersion >= 8) {
            this.prevDeltaLsn = LogUtils.readPackedLong(itemBuffer);
        }
        int numDeltas = LogUtils.readInt(itemBuffer, entryVersion < 6);
        for (int i = 0; i < numDeltas; ++i) {
            DeltaInfo info = new DeltaInfo();
            info.readFromLog(itemBuffer, entryVersion);
            this.deltas.add(info);
        }
        this.deltas.trimToSize();
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        sb.append("<lastFullLsn>");
        sb.append(DbLsn.getNoFormatString(this.lastFullLsn));
        sb.append("</lastFullLsn>");
        sb.append("<prevDeltaLsn>");
        sb.append(DbLsn.getNoFormatString(this.prevDeltaLsn));
        sb.append("</prevDeltaLsn>");
        sb.append("<deltas size=\"").append(this.deltas.size()).append("\"/>");
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = this.deltas.get(i);
            info.dumpLog(sb, verbose);
        }
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public long getMemorySize() {
        long size = MemoryBudget.BINDELTA_OVERHEAD + MemoryBudget.ARRAYLIST_OVERHEAD + MemoryBudget.objectArraySize(this.deltas.size());
        for (DeltaInfo info : this.deltas) {
            size += info.getMemorySize();
        }
        return size;
    }
}

