/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.IterationWrapper;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SailBaseIteration<T, E extends Exception>
extends IterationWrapper<T, E> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SailConnectionBase connection;
    private final Throwable creatorTrace;

    public SailBaseIteration(CloseableIteration<? extends T, ? extends E> iter, SailConnectionBase connection) {
        super(iter);
        this.connection = connection;
        this.creatorTrace = SailBase.debugEnabled() ? new Throwable() : null;
    }

    public boolean hasNext() throws E {
        if (super.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    protected void handleClose() throws E {
        super.handleClose();
        this.connection.iterationClosed(this);
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.forceClose();
        }
        super.finalize();
    }

    protected void forceClose() throws E {
        if (this.creatorTrace != null) {
            this.logger.warn("Forced closing of unclosed iteration that was created in:", this.creatorTrace);
        }
        this.close();
    }
}

