/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Shape;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentStorageException;
import com.thinkaurelius.titan.diskstorage.StorageException;
import com.thinkaurelius.titan.diskstorage.TemporaryStorageException;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements IndexProvider {
    private Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    private static final String DOCID = "_____elementid";
    private static final String GEOID = "_____geo";
    private static final int MAX_STRING_FIELD_LEN = 256;
    private static final Version LUCENE_VERSION = Version.LUCENE_41;
    private static final int GEO_MAX_LEVELS = 11;
    private final Analyzer analyzer = new StandardAnalyzer(LUCENE_VERSION);
    private final Map<String, IndexWriter> writers = new HashMap<String, IndexWriter>(4);
    private final ReentrantLock writerLock = new ReentrantLock();
    private Map<String, SpatialStrategy> spatial = new ConcurrentHashMap<String, SpatialStrategy>(12);
    private SpatialContext ctx = SpatialContext.GEO;
    private final String basePath;

    public LuceneIndex(Configuration config) {
        String dir = (String)config.get(GraphDatabaseConfiguration.INDEX_DIRECTORY, new String[0]);
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(directory.exists() && directory.isDirectory() && directory.canWrite())) {
            throw new IllegalArgumentException("Cannot access or write to directory: " + dir);
        }
        this.basePath = directory.getAbsolutePath();
        this.log.debug("Configured Lucene to use base directory [{}]", (Object)this.basePath);
    }

    private Directory getStoreDirectory(String store) throws StorageException {
        Preconditions.checkArgument((boolean)StringUtils.isAlphanumeric((String)store), (String)"Invalid store name: %s", (Object[])new Object[]{store});
        String dir = this.basePath + File.separator + store;
        try {
            File path = new File(dir);
            if (!path.exists()) {
                path.mkdirs();
            }
            if (!(path.exists() && path.isDirectory() && path.canWrite())) {
                throw new PermanentStorageException("Cannot access or write to directory: " + dir);
            }
            this.log.debug("Opening store directory [{}]", (Object)path);
            return FSDirectory.open((File)path);
        }
        catch (IOException e) {
            throw new PermanentStorageException("Could not open directory: " + dir, (Throwable)e);
        }
    }

    private IndexWriter getWriter(String store) throws StorageException {
        Preconditions.checkArgument((boolean)this.writerLock.isHeldByCurrentThread());
        IndexWriter writer = this.writers.get(store);
        if (writer == null) {
            IndexWriterConfig iwc = new IndexWriterConfig(LUCENE_VERSION, this.analyzer);
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            try {
                writer = new IndexWriter(this.getStoreDirectory(store), iwc);
                this.writers.put(store, writer);
            }
            catch (IOException e) {
                throw new PermanentStorageException("Could not create writer", (Throwable)e);
            }
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpatialStrategy getSpatialStrategy(String key) {
        SpatialStrategy strategy = this.spatial.get(key);
        if (strategy == null) {
            Map<String, SpatialStrategy> map = this.spatial;
            synchronized (map) {
                if (this.spatial.containsKey(key)) {
                    return this.spatial.get(key);
                }
                strategy = new PointVectorStrategy(this.ctx, key);
                this.spatial.put(key, strategy);
            }
        }
        return strategy;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws StorageException {
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtil.isString((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        Transaction ltx = (Transaction)tx;
        this.writerLock.lock();
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String storename = stores.getKey();
                IndexWriter writer = this.getWriter(storename);
                DirectoryReader reader = DirectoryReader.open((IndexWriter)writer, (boolean)true);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docid = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    Term docTerm = new Term(DOCID, docid);
                    if (mutation.isDeleted()) {
                        this.log.trace("Deleted entire document [{}]", (Object)docid);
                        writer.deleteDocuments(docTerm);
                        continue;
                    }
                    Document doc = null;
                    TopDocs hits = searcher.search((Query)new TermQuery(docTerm), 10);
                    HashMap geofields = Maps.newHashMap();
                    if (hits.scoreDocs.length == 0) {
                        this.log.trace("Creating new document for [{}]", (Object)docid);
                        doc = new Document();
                        StringField docidField = new StringField(DOCID, docid, Field.Store.YES);
                        doc.add((IndexableField)docidField);
                    } else {
                        if (hits.scoreDocs.length > 1) {
                            throw new IllegalArgumentException("More than one document found for document id: " + docid);
                        }
                        this.log.trace("Updating existing document for [{}]", (Object)docid);
                        int docId = hits.scoreDocs[0].doc;
                        doc = searcher.doc(docId);
                        for (Object field : doc.getFields()) {
                            if (!field.stringValue().startsWith(GEOID)) continue;
                            geofields.put(field.name(), this.ctx.readShape(field.stringValue().substring(GEOID.length())));
                        }
                    }
                    Preconditions.checkNotNull((Object)doc);
                    for (IndexEntry indexEntry : mutation.getDeletions()) {
                        String key = indexEntry.field;
                        if (doc.getField(key) == null) continue;
                        this.log.trace("Removing field [{}] on document [{}]", (Object)key, (Object)docid);
                        doc.removeFields(key);
                        geofields.remove(key);
                    }
                    for (IndexEntry indexEntry : mutation.getAdditions()) {
                        this.log.trace("Adding field [{}] on document [{}]", (Object)indexEntry.field, (Object)docid);
                        if (doc.getField(indexEntry.field) != null) {
                            doc.removeFields(indexEntry.field);
                        }
                        if (indexEntry.value instanceof Number) {
                            Object field;
                            field = null;
                            field = AttributeUtil.isWholeNumber((Number)((Number)indexEntry.value)) ? new LongField(indexEntry.field, ((Number)indexEntry.value).longValue(), Field.Store.YES) : new DoubleField(indexEntry.field, ((Number)indexEntry.value).doubleValue(), Field.Store.YES);
                            doc.add(field);
                            continue;
                        }
                        if (AttributeUtil.isString((Object)indexEntry.value)) {
                            TextField field;
                            String str = (String)indexEntry.value;
                            Mapping mapping = Mapping.getMapping((String)storename, (String)indexEntry.field, (KeyInformation.IndexRetriever)informations);
                            switch (mapping) {
                                case DEFAULT: 
                                case TEXT: {
                                    field = new TextField(indexEntry.field, str, Field.Store.YES);
                                    break;
                                }
                                case STRING: {
                                    field = new StringField(indexEntry.field, str, Field.Store.YES);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Illegal mapping specified: " + mapping);
                                }
                            }
                            doc.add((IndexableField)field);
                            continue;
                        }
                        if (indexEntry.value instanceof Geoshape) {
                            Shape shape = ((Geoshape)indexEntry.value).convert2Spatial4j();
                            geofields.put(indexEntry.field, shape);
                            doc.add((IndexableField)new StoredField(indexEntry.field, GEOID + this.ctx.toString(shape)));
                            continue;
                        }
                        throw new IllegalArgumentException("Unsupported type: " + indexEntry.value);
                    }
                    for (Map.Entry entry2 : geofields.entrySet()) {
                        this.log.trace("Updating geo-indexes for key {}", entry2.getKey());
                        for (Field f : this.getSpatialStrategy((String)entry2.getKey()).createIndexableFields((Shape)entry2.getValue())) {
                            doc.add((IndexableField)f);
                        }
                    }
                    writer.updateDocument(new Term(DOCID, docid), (Iterable)doc);
                }
                writer.commit();
            }
            ltx.postCommit();
        }
        catch (IOException e) {
            throw new TemporaryStorageException("Could not update Lucene index", (Throwable)e);
        }
        finally {
            this.writerLock.unlock();
        }
    }

    private static final Sort getSortOrder(IndexQuery query) {
        Sort sort = new Sort();
        List orders = query.getOrder();
        if (!orders.isEmpty()) {
            SortField[] fields = new SortField[orders.size()];
            for (int i = 0; i < orders.size(); ++i) {
                IndexQuery.OrderEntry order = (IndexQuery.OrderEntry)orders.get(i);
                SortField.Type sortType = null;
                Class datatype = order.getDatatype();
                if (AttributeUtil.isString((Class)datatype)) {
                    sortType = SortField.Type.STRING;
                } else if (AttributeUtil.isWholeNumber((Class)datatype)) {
                    sortType = SortField.Type.LONG;
                } else if (AttributeUtil.isDecimal((Class)datatype)) {
                    sortType = SortField.Type.DOUBLE;
                } else {
                    Preconditions.checkArgument((boolean)false, (String)"Unsupported order specified on field [%s] with datatype [%s]", (Object[])new Object[]{order.getKey(), datatype});
                }
                fields[i] = new SortField(order.getKey(), sortType, order.getOrder() == Order.DESC);
            }
            sort.setSort(fields);
        }
        return sort;
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        Filter q = this.convertQuery(query.getCondition(), informations.get(query.getStore()));
        try {
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return ImmutableList.of();
            }
            long time = System.currentTimeMillis();
            TopFieldDocs docs = searcher.search((Query)new MatchAllDocsQuery(), q, query.hasLimit() ? query.getLimit() : 0x7FFFFFFE, LuceneIndex.getSortOrder(query));
            this.log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            ArrayList<String> result = new ArrayList<String>(docs.scoreDocs.length);
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                result.add(searcher.doc(docs.scoreDocs[i].doc).getField(DOCID).stringValue());
            }
            return result;
        }
        catch (IOException e) {
            throw new TemporaryStorageException("Could not execute Lucene query", (Throwable)e);
        }
    }

    private static final Filter numericFilter(String key, Cmp relation, Number value) {
        switch (relation) {
            case EQUAL: {
                return value instanceof Long || value instanceof Integer ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)value.longValue(), (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)value.doubleValue(), (boolean)true, (boolean)true);
            }
            case NOT_EQUAL: {
                BooleanFilter q = new BooleanFilter();
                if (value instanceof Long || value instanceof Integer) {
                    q.add((Filter)NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)false), BooleanClause.Occur.SHOULD);
                    q.add((Filter)NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true), BooleanClause.Occur.SHOULD);
                } else {
                    q.add((Filter)NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)false), BooleanClause.Occur.SHOULD);
                    q.add((Filter)NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)false, (boolean)true), BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            case LESS_THAN: {
                return value instanceof Long || value instanceof Integer ? NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)false) : NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)false);
            }
            case LESS_THAN_EQUAL: {
                return value instanceof Long || value instanceof Integer ? NumericRangeFilter.newLongRange((String)key, (Long)Long.MIN_VALUE, (Long)value.longValue(), (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)Double.MIN_VALUE, (Double)value.doubleValue(), (boolean)true, (boolean)true);
            }
            case GREATER_THAN: {
                return value instanceof Long || value instanceof Integer ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)false, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)false, (boolean)true);
            }
            case GREATER_THAN_EQUAL: {
                return value instanceof Long || value instanceof Integer ? NumericRangeFilter.newLongRange((String)key, (Long)value.longValue(), (Long)Long.MAX_VALUE, (boolean)true, (boolean)true) : NumericRangeFilter.newDoubleRange((String)key, (Double)value.doubleValue(), (Double)Double.MAX_VALUE, (boolean)true, (boolean)true);
            }
        }
        throw new IllegalArgumentException("Unexpected relation: " + relation);
    }

    private final Filter convertQuery(Condition<?> condition, KeyInformation.StoreRetriever informations) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Preconditions.checkArgument((boolean)(value instanceof Number));
                return LuceneIndex.numericFilter(key, (Cmp)titanPredicate, (Number)value);
            }
            if (value instanceof String) {
                Mapping map = Mapping.getMapping((KeyInformation)informations.get(key));
                if (!(map != Mapping.DEFAULT && map != Mapping.TEXT || titanPredicate.toString().startsWith("CONTAINS"))) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (titanPredicate == Text.CONTAINS) {
                    value = ((String)value).toLowerCase();
                    return new TermsFilter(new Term[]{new Term(key, (String)value)});
                }
                if (titanPredicate == Text.CONTAINS_PREFIX) {
                    value = ((String)value).toLowerCase();
                    return new PrefixFilter(new Term(key, (String)value));
                }
                if (titanPredicate == Text.PREFIX) {
                    return new PrefixFilter(new Term(key, (String)value));
                }
                if (titanPredicate == Cmp.EQUAL) {
                    return new TermsFilter(new Term[]{new Term(key, (String)value)});
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    BooleanFilter q = new BooleanFilter();
                    q.add((Filter)new TermsFilter(new Term[]{new Term(key, (String)value)}), BooleanClause.Occur.MUST_NOT);
                    return q;
                }
                throw new IllegalArgumentException("Relation is not supported for string value: " + titanPredicate);
            }
            if (value instanceof Geoshape) {
                Preconditions.checkArgument((titanPredicate == Geo.WITHIN ? 1 : 0) != 0, (Object)("Relation is not supported for geo value: " + titanPredicate));
                Shape shape = ((Geoshape)value).convert2Spatial4j();
                SpatialArgs args = new SpatialArgs(SpatialOperation.IsWithin, shape);
                return this.getSpatialStrategy(key).makeFilter(args);
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            BooleanFilter q = new BooleanFilter();
            q.add(this.convertQuery(((Not)condition).getChild(), informations), BooleanClause.Occur.MUST_NOT);
            return q;
        }
        if (condition instanceof And) {
            BooleanFilter q = new BooleanFilter();
            for (Condition c : condition.getChildren()) {
                q.add(this.convertQuery(c, informations), BooleanClause.Occur.MUST);
            }
            return q;
        }
        if (condition instanceof Or) {
            BooleanFilter q = new BooleanFilter();
            for (Condition c : condition.getChildren()) {
                q.add(this.convertQuery(c, informations), BooleanClause.Occur.SHOULD);
            }
            return q;
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws StorageException {
        Query q;
        try {
            q = new QueryParser(LUCENE_VERSION, "_all", this.analyzer).parse(query.getQuery());
        }
        catch (ParseException e) {
            throw new PermanentStorageException("Could not parse raw query: " + query.getQuery(), (Throwable)e);
        }
        try {
            int adjustedLimit;
            IndexSearcher searcher = ((Transaction)tx).getSearcher(query.getStore());
            if (searcher == null) {
                return ImmutableList.of();
            }
            long time = System.currentTimeMillis();
            int offset = query.getOffset();
            int n = adjustedLimit = query.hasLimit() ? query.getLimit() : 0x7FFFFFFE;
            adjustedLimit = adjustedLimit < 0x7FFFFFFE - offset ? (adjustedLimit += offset) : 0x7FFFFFFE;
            TopDocs docs = searcher.search(q, adjustedLimit);
            this.log.debug("Executed query [{}] in {} ms", (Object)q, (Object)(System.currentTimeMillis() - time));
            ArrayList<RawQuery.Result<String>> result = new ArrayList<RawQuery.Result<String>>(docs.scoreDocs.length);
            for (int i = offset; i < docs.scoreDocs.length; ++i) {
                result.add((RawQuery.Result<String>)new RawQuery.Result((Object)searcher.doc(docs.scoreDocs[i].doc).getField(DOCID).stringValue(), (double)docs.scoreDocs[i].score));
            }
            return result;
        }
        catch (IOException e) {
            throw new TemporaryStorageException("Could not execute Lucene query", (Throwable)e);
        }
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws StorageException {
        return new Transaction(config);
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        if (information.getCardinality() != Cardinality.SINGLE) {
            return false;
        }
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (mapping != Mapping.DEFAULT && !AttributeUtil.isString((Class)dataType)) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            if (titanPredicate instanceof Cmp) {
                return true;
            }
        } else {
            if (dataType == Geoshape.class) {
                return titanPredicate == Geo.WITHIN;
            }
            if (AttributeUtil.isString((Class)dataType)) {
                switch (mapping) {
                    case DEFAULT: 
                    case TEXT: {
                        return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX;
                    }
                    case STRING: {
                        return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.PREFIX;
                    }
                }
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        if (information.getCardinality() != Cardinality.SINGLE) {
            return false;
        }
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Geoshape.class ? mapping == Mapping.DEFAULT : AttributeUtil.isString((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT);
    }

    public void close() throws StorageException {
        try {
            for (IndexWriter w : this.writers.values()) {
                w.close();
            }
        }
        catch (IOException e) {
            throw new PermanentStorageException("Could not close writers", (Throwable)e);
        }
    }

    public void clearStorage() throws StorageException {
        try {
            FileUtils.deleteDirectory((File)new File(this.basePath));
        }
        catch (IOException e) {
            throw new PermanentStorageException("Could not delete lucene directory: " + this.basePath, (Throwable)e);
        }
    }

    private class Transaction
    implements BaseTransactionConfigurable {
        private final BaseTransactionConfig config;
        private final Set<String> updatedStores = Sets.newHashSet();
        private final Map<String, IndexSearcher> searchers = new HashMap<String, IndexSearcher>(4);

        private Transaction(BaseTransactionConfig config) {
            this.config = config;
        }

        private synchronized IndexSearcher getSearcher(String store) throws StorageException {
            IndexSearcher searcher = this.searchers.get(store);
            if (searcher == null) {
                DirectoryReader reader = null;
                try {
                    reader = DirectoryReader.open((Directory)LuceneIndex.this.getStoreDirectory(store));
                    searcher = new IndexSearcher((IndexReader)reader);
                }
                catch (IndexNotFoundException e) {
                    searcher = null;
                }
                catch (IOException e) {
                    throw new PermanentStorageException("Could not open index reader on store: " + store, (Throwable)e);
                }
                this.searchers.put(store, searcher);
            }
            return searcher;
        }

        public void postCommit() throws StorageException {
            this.close();
            this.searchers.clear();
        }

        public void commit() throws StorageException {
            this.close();
        }

        public void rollback() throws StorageException {
            this.close();
        }

        private void close() throws StorageException {
            try {
                for (IndexSearcher searcher : this.searchers.values()) {
                    if (searcher == null) continue;
                    searcher.getIndexReader().close();
                }
            }
            catch (IOException e) {
                throw new PermanentStorageException("Could not close searcher", (Throwable)e);
            }
        }

        public BaseTransactionConfig getConfiguration() {
            return this.config;
        }
    }
}

