/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.console;

import com.tinkerpop.pipes.util.iterators.SingleIterator;
import com.tinkerpop.rexster.client.RemoteRexsterSession;
import com.tinkerpop.rexster.console.ConsoleSettings;
import com.tinkerpop.rexster.console.ResultAndBindings;
import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import jline.ConsoleReader;
import jline.History;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RexsterConsole {
    private RemoteRexsterSession session = null;
    private List<String> currentBindings = new ArrayList<String>();
    private final PrintStream output = System.out;
    private final ConsoleSettings settings;
    private static final String REXSTER_HISTORY = ".rexster_history";

    public RexsterConsole(ConsoleSettings settings) {
        this.settings = settings;
    }

    public void start() throws Exception {
        if (this.settings.isExecuteMode()) {
            this.oneTimeExecuteScript(RexsterConsole.readFile(this.settings.getFileToExecute()));
        } else {
            this.writeAsciiArt();
            this.acceptReplCommands();
        }
    }

    private void writeAsciiArt() {
        this.output.println("        (l_(l");
        this.output.println("(_______( 0 0");
        this.output.println("(        (-Y-) <woof>");
        this.output.println("l l-----l l");
        this.output.println("l l,,   l l,,");
    }

    private void acceptReplCommands() throws Exception {
        this.output.println("opening session " + this.settings.getHostPort());
        this.initAndOpenSessionFromSettings();
        if (this.session.isOpen()) {
            this.output.println("?h for help");
            this.primaryLoop();
        } else {
            this.output.println("could not connect to the Rexster server");
        }
    }

    private void oneTimeExecuteScript(String script) {
        this.initAndOpenSessionFromSettings();
        if (!this.session.isOpen()) {
            this.output.println("could not connect to the Rexster server");
        } else {
            this.executeScript(script, false);
        }
        this.closeConsole();
    }

    private void initAndOpenSessionFromSettings() {
        this.session = new RemoteRexsterSession(this.settings.getHost(), this.settings.getPort(), this.settings.getTimeout(), this.settings.getUsername(), this.settings.getPassword());
        this.session.open();
    }

    private void primaryLoop() throws Exception {
        ConsoleReader reader = this.getInputReader();
        String line = "";
        this.output.println();
        while (line != null) {
            try {
                line = "";
                boolean submit = false;
                boolean newline = false;
                while (!submit) {
                    line = newline ? line + "\n" + reader.readLine(RexsterConsole.makeSpace(this.getPrompt().length())) : line + "\n" + reader.readLine(this.getPrompt());
                    if (line.endsWith(" .")) {
                        newline = true;
                        line = line.substring(0, line.length() - 2);
                        continue;
                    }
                    line = line.trim();
                    submit = true;
                }
                if (line.isEmpty()) continue;
                if (line.equals("?q")) {
                    this.closeConsole();
                    return;
                }
                if (line.equals("?h")) {
                    this.printHelp();
                    continue;
                }
                if (line.equals("?b")) {
                    this.printBindings();
                    continue;
                }
                if (line.equals("?r")) {
                    this.resetSessionWithRexster();
                    continue;
                }
                if (line.startsWith("?e")) {
                    String fileToExecute = line.substring("?e".length()).trim();
                    if (fileToExecute == null || fileToExecute.isEmpty()) {
                        this.output.print("specify the file to execute");
                        continue;
                    }
                    try {
                        this.executeScript(RexsterConsole.readFile(fileToExecute));
                    }
                    catch (IOException ioe) {
                        this.output.println("could not read the file specified");
                    }
                    continue;
                }
                if (line.equals("?l")) {
                    this.printAvailableLanguages();
                    continue;
                }
                if (line.startsWith("?")) {
                    this.changeLanugage(line);
                    continue;
                }
                this.executeScript(line);
            }
            catch (Exception e) {
                this.output.println("Evaluation error: " + e.getMessage());
            }
        }
    }

    private void changeLanugage(String line) {
        String langToChangeTo = line.substring(1);
        if (langToChangeTo == null || langToChangeTo.isEmpty()) {
            this.output.println("specify a language on Rexster ?<language-name>");
            this.printAvailableLanguages();
        } else if (this.session.isAvailableLanguage(langToChangeTo)) {
            this.settings.setLanguage(langToChangeTo);
        } else {
            this.output.println("not a valid language on Rexster: [" + langToChangeTo + "].");
            this.printAvailableLanguages();
        }
    }

    private void resetSessionWithRexster() {
        this.output.print("resetting session with Rexster " + this.settings.getHostPort());
        if (this.session != null) {
            this.session.reset();
        } else {
            this.initAndOpenSessionFromSettings();
        }
        this.currentBindings.clear();
        this.output.println("--> done");
    }

    private void closeConsole() {
        this.output.print("closing session with Rexster " + this.settings.getHostPort());
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.output.println("--> done");
    }

    private ConsoleReader getInputReader() throws IOException {
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setUseHistory(true);
        try {
            History history = new History();
            history.setHistoryFile(new File(System.getProperty("user.home") + "/" + REXSTER_HISTORY));
            reader.setHistory(history);
        }
        catch (IOException e) {
            System.err.println("Could not find history file");
        }
        return reader;
    }

    private void executeScript(String line) {
        this.executeScript(line, true);
    }

    private void executeScript(String line, boolean showPrefix) {
        ResultAndBindings result = this.eval(line, this.settings.getLanguage(), this.session);
        Object itty = result.getResult() instanceof Iterator ? (Iterator)result.getResult() : (result.getResult() instanceof Iterable ? ((Iterable)result.getResult()).iterator() : (result.getResult() instanceof Map ? ((Map)result.getResult()).entrySet().iterator() : new SingleIterator(result.getResult())));
        while (itty.hasNext()) {
            Object o = itty.next();
            if (o == null) continue;
            if (showPrefix) {
                this.output.println("==>" + o);
                continue;
            }
            this.output.println(o);
        }
        this.currentBindings = result.getBindings();
    }

    private void printAvailableLanguages() {
        this.output.println("-= Available Languages =-");
        Iterator languages = this.session.getAvailableLanguages();
        while (languages.hasNext()) {
            this.output.println("?" + (String)languages.next());
        }
    }

    public void printHelp() {
        this.output.println("-= Console Specific =-");
        this.output.println("?<language-name>: jump to engine");
        this.output.println("?l: list of available languages on Rexster");
        this.output.println("?b: print available bindings in the session");
        this.output.println("?r: reset the rexster session");
        this.output.println("?e <file-name>: execute a script file");
        this.output.println("?q: quit");
        this.output.println("?h: displays this message");
        this.output.println("");
        this.output.println("-= Rexster Context =-");
        this.output.println("rexster.getGraph(graphName) - gets a Graph instance");
        this.output.println("   :graphName - [String] - the name of a graph configured within Rexster");
        this.output.println("rexster.getGraphNames() - gets the set of graph names configured within Rexster");
        this.output.println("rexster.getVersion() - gets the version of Rexster server");
        this.output.println("");
    }

    public void printBindings() {
        for (String binding : this.currentBindings) {
            this.output.println("==>" + binding);
        }
    }

    public String getPrompt() {
        return "rexster[" + this.settings.getLanguage() + "]> ";
    }

    public static String makeSpace(int number) {
        String space = "";
        for (int i = 0; i < number; ++i) {
            space = space + " ";
        }
        return space;
    }

    public List<String> bindingsAsList(ScriptResponseMessage msg) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (Map.Entry pair : msg.Bindings.entrySet()) {
            if (pair.getValue() == null) {
                bindings.add(pair.getKey() + "=null");
                continue;
            }
            bindings.add(pair.getKey() + "=" + pair.getValue().toString());
        }
        return bindings;
    }

    public List<String> consoleLinesAsList(ScriptResponseMessage msg) {
        ArrayList<String> list = new ArrayList<String>();
        for (String line : (ArrayList)msg.Results.get()) {
            list.add(line);
        }
        return list;
    }

    private ResultAndBindings eval(String script, String scriptEngineName, RemoteRexsterSession session) {
        ResultAndBindings returnValue = null;
        try {
            ArrayList<String> bindings;
            ArrayList<String> lines;
            block8: {
                assert (session.isOpen());
                ScriptRequestMessage scriptMessage = new ScriptRequestMessage();
                scriptMessage.Script = script;
                scriptMessage.LanguageName = scriptEngineName;
                scriptMessage.metaSetInSession(Boolean.valueOf(true));
                scriptMessage.metaSetTransaction(false);
                scriptMessage.metaSetIsolate(false);
                scriptMessage.metaSetConsole(true);
                scriptMessage.setRequestAsUUID(UUID.randomUUID());
                RexProMessage resultMessage = session.sendRequest((RexProMessage)scriptMessage, 3, 500);
                lines = new ArrayList<String>();
                bindings = new ArrayList();
                try {
                    if (resultMessage instanceof ScriptResponseMessage) {
                        ScriptResponseMessage responseMessage = (ScriptResponseMessage)resultMessage;
                        bindings = this.bindingsAsList(responseMessage);
                        lines = this.consoleLinesAsList(responseMessage);
                        break block8;
                    }
                    if (resultMessage instanceof ErrorResponseMessage) {
                        final ErrorResponseMessage errorMessage = (ErrorResponseMessage)resultMessage;
                        lines = new ArrayList<String>(){
                            {
                                this.add(errorMessage.ErrorMessage);
                            }
                        };
                        break block8;
                    }
                    throw new RuntimeException("Unexpected message type received from RexPro Server.");
                }
                catch (Exception iae) {
                    lines.add(iae.getMessage());
                }
            }
            Iterator result = lines.iterator();
            if (lines.size() == 1) {
                result = lines.get(0);
            }
            returnValue = new ResultAndBindings(result, bindings);
        }
        catch (Exception e) {
            System.out.println("The session with Rexster Server may have been lost.  Please try again or refresh your session with ?r");
        }
        return returnValue;
    }

    private static String readFile(String file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) throws Exception {
        try {
            ConsoleSettings settings = new ConsoleSettings(args);
            new RexsterConsole(settings).start();
        }
        catch (Exception ex) {
            RexsterConsole.die(ex);
        }
    }

    private static void die(Throwable ex) {
        System.out.println(ex.getMessage() + " (stack trace follows)");
        ex.printStackTrace();
        System.exit(1);
    }

    static {
        ArrayList<Logger> loggers = Collections.list(LogManager.getCurrentLoggers());
        loggers.add(LogManager.getRootLogger());
        for (Logger logger : loggers) {
            logger.setLevel(Level.OFF);
        }
    }
}

