/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.console;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ConsoleSettings {
    private final String DEFAULT_HOST = "127.0.0.1";
    private final int DEFAULT_PORT = 8184;
    private final String DEFAULT_LANGUAGE = "groovy";
    private final int DEFAULT_TIMEOUT = 100;
    private final String host;
    private final int port;
    private final int timeout;
    private final String username;
    private final String password;
    private final String fileToExecute;
    private String language;

    public ConsoleSettings(String[] commandLineArgs) throws Exception {
        CommandLine line = ConsoleSettings.getCliInput(commandLineArgs);
        this.host = line.getOptionValue("rexsterhost", "127.0.0.1");
        String portString = line.getOptionValue("rexsterport");
        this.port = this.parseInt(portString, 8184);
        if (line.hasOption("rexsterport") && !Integer.toString(this.port).equals(portString)) {
            System.out.println("the rexsterport parameter must be an integer value. Defaulting to: [" + this.port + "]");
        }
        this.language = line.getOptionValue("language", "groovy");
        String timeoutString = line.getOptionValue("timeout");
        this.timeout = this.parseInt(timeoutString, 100);
        if (line.hasOption("timeout") && !Integer.toString(this.timeout).equals(timeoutString)) {
            System.out.println("the timeout parameter must be an integer value. Defaulting to: " + this.timeout);
        }
        this.username = line.getOptionValue("user", "");
        this.password = line.getOptionValue("pass", "");
        this.fileToExecute = line.getOptionValue("execute", null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getUsername() {
        return this.username;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getFileToExecute() {
        return this.fileToExecute;
    }

    public boolean isExecuteMode() {
        return this.fileToExecute != null;
    }

    public String getHostPort() {
        return "[" + this.host + ":" + this.port + "]";
    }

    private int parseInt(String intString, int intDefault) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            return intDefault;
        }
    }

    private static Options getCliOptions() {
        Option help = new Option("h", "help", false, "print this message");
        OptionBuilder.withArgName((String)"host-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the rexster server to connect to");
        OptionBuilder.withLongOpt((String)"rexsterhost");
        Option hostName = OptionBuilder.create((String)"rh");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the port of the rexster server that is serving rexpro");
        OptionBuilder.withLongOpt((String)"rexsterport");
        Option port = OptionBuilder.create((String)"rp");
        OptionBuilder.withArgName((String)"language");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the script engine language to use by default");
        OptionBuilder.withLongOpt((String)"language");
        Option language = OptionBuilder.create((String)"l");
        OptionBuilder.withArgName((String)"seconds");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"time allowed when waiting for results from server (default 100 seconds)");
        OptionBuilder.withLongOpt((String)"timeout");
        Option timeout = OptionBuilder.create((String)"t");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"script to execute remotely");
        OptionBuilder.withLongOpt((String)"execute");
        Option scriptFile = OptionBuilder.create((String)"e");
        OptionBuilder.withArgName((String)"username");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"username for authentication (if needed)");
        OptionBuilder.withLongOpt((String)"user");
        Option username = OptionBuilder.create((String)"u");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"password for authentication (if needed)");
        OptionBuilder.withLongOpt((String)"pass");
        Option password = OptionBuilder.create((String)"p");
        Options options = new Options();
        options.addOption(help);
        options.addOption(hostName);
        options.addOption(port);
        options.addOption(language);
        options.addOption(timeout);
        options.addOption(scriptFile);
        options.addOption(username);
        options.addOption(password);
        return options;
    }

    private static CommandLine getCliInput(String[] args) throws Exception {
        CommandLine line;
        Options options = ConsoleSettings.getCliOptions();
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            throw new Exception("Parsing failed.  Reason: " + exp.getMessage());
        }
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("rexster console", options);
            System.exit(0);
        }
        return line;
    }
}

