/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.system;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;

public class NetworkUtil {
    public static String getLoopbackAddress() {
        try {
            return InetAddress.getByName("localhost").getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getLocalAddress() {
        return NetworkUtil.getLocalHost().getHostAddress();
    }

    public static String getLocalHostName() {
        return NetworkUtil.getLocalHost().getHostName();
    }

    public static boolean hasLocalAddress(Collection<String> endpoints) {
        return endpoints.contains(NetworkUtil.getLoopbackAddress()) || endpoints.contains(NetworkUtil.getLocalAddress()) || endpoints.contains(NetworkUtil.getLocalHostName());
    }

    public static boolean isLocalConnection(String hostname) {
        InetAddress localhost = NetworkUtil.getLocalHost();
        return hostname.equalsIgnoreCase(NetworkUtil.getLoopbackAddress()) || hostname.equals(localhost.getHostAddress()) || hostname.equals(localhost.getHostName()) || hostname.equals(localhost.getCanonicalHostName());
    }
}

